/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class BlockExtendItem
extends Item {
    private static final int MAX_RANGE = 10;
    private static final int MAX_AREA_BLOCKS = 50;
    private static final List<String> MODES = List.of("Area", "Horizontal Line", "Vertical Line");

    public BlockExtendItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos origin = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState state = level.getBlockState(origin);
        Block block = state.getBlock();
        ItemStack stack = context.getItemInHand();
        int modeIndex = Optional.ofNullable((Integer)stack.get(ModDataComponents.EXTEND_MODE)).orElse(0);
        String mode = MODES.get(modeIndex);
        Set<BlockPos> baseBlocks = this.findConnectedBlocks(level, origin, block, face, 50);
        LinkedHashSet<BlockPos> targets = new LinkedHashSet<BlockPos>();
        block5 : switch (mode) {
            case "Area": {
                int placedCount = 0;
                for (BlockPos base : baseBlocks) {
                    if (placedCount >= 50) break block5;
                    BlockPos forward = base.relative(face);
                    if (!level.isLoaded(forward) || !level.isEmptyBlock(forward)) continue;
                    targets.add(forward);
                    ++placedCount;
                }
                break;
            }
            case "Horizontal Line": {
                BlockPos right;
                BlockPos left;
                int i;
                Direction playerFacing = player.getDirection();
                Direction sideways = playerFacing.getClockWise();
                for (i = 1; i <= 5 && level.getBlockState(left = origin.relative(sideways.getOpposite(), i)).is(block); ++i) {
                    BlockPos forwardLeft = left.relative(face);
                    if (!level.isLoaded(forwardLeft) || !level.isEmptyBlock(forwardLeft)) continue;
                    targets.add(forwardLeft);
                }
                for (i = 1; i <= 5 && level.getBlockState(right = origin.relative(sideways, i)).is(block); ++i) {
                    BlockPos forwardRight = right.relative(face);
                    if (!level.isLoaded(forwardRight) || !level.isEmptyBlock(forwardRight)) continue;
                    targets.add(forwardRight);
                }
                BlockPos originForward = origin.relative(face);
                if (!level.isLoaded(originForward) || !level.isEmptyBlock(originForward)) break;
                targets.add(originForward);
                break;
            }
            case "Vertical Line": {
                BlockPos down;
                BlockPos up;
                int i;
                for (i = 1; i <= 5 && level.getBlockState(up = origin.above(i)).is(block); ++i) {
                    BlockPos forwardUp = up.relative(face);
                    if (!level.isLoaded(forwardUp) || !level.isEmptyBlock(forwardUp)) continue;
                    targets.add(forwardUp);
                }
                for (i = 1; i <= 5 && level.getBlockState(down = origin.below(i)).is(block); ++i) {
                    BlockPos forwardDown = down.relative(face);
                    if (!level.isLoaded(forwardDown) || !level.isEmptyBlock(forwardDown)) continue;
                    targets.add(forwardDown);
                }
                BlockPos originForward = origin.relative(face);
                if (!level.isLoaded(originForward) || !level.isEmptyBlock(originForward)) break;
                targets.add(originForward);
            }
        }
        int placed = 0;
        for (BlockPos target : targets) {
            if (!player.isCreative() && !this.removeBlockFromInventory(player, block)) continue;
            BlockState newState = this.copyOrientation(state, block.defaultBlockState());
            level.setBlock(target, newState, 2);
            ++placed;
        }
        if (placed > 0) {
            level.playSound(null, origin, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 0.8f, 1.0f);
            player.displayClientMessage((Component)Component.literal((String)("Extended " + placed + " blocks (" + mode + ")")), true);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.literal((String)"No space or no matching blocks."), true);
        return InteractionResult.FAIL;
    }

    private BlockState copyOrientation(BlockState fromState, BlockState toState) {
        for (Property prop : fromState.getProperties()) {
            String name = prop.getName();
            if (!name.equals("facing") && !name.equals("axis") && !name.equals("half") && !name.equals("rotation") || !toState.hasProperty(prop)) continue;
            try {
                toState = (BlockState)toState.setValue(prop, fromState.getValue(prop));
            }
            catch (Exception exception) {}
        }
        return toState;
    }

    private Set<BlockPos> findConnectedBlocks(Level level, BlockPos start, Block block, Direction face, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        visited.add(start);
        queue.add(start);
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            for (Direction dir : this.getPlaneDirections(face)) {
                BlockPos neighbor = current.relative(dir);
                if (!level.getBlockState(neighbor).is(block) || !visited.add(neighbor)) continue;
                queue.add(neighbor);
            }
        }
        return visited;
    }

    private List<Direction> getPlaneDirections(Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
            case Direction.NORTH, Direction.SOUTH -> List.of(Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN);
            case Direction.EAST, Direction.WEST -> List.of(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN);
        };
    }

    private boolean removeBlockFromInventory(Player player, Block block) {
        if (player.isCreative()) {
            return true;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(block.asItem())) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int modeIndex = Optional.ofNullable((Integer)stack.get(ModDataComponents.EXTEND_MODE)).orElse(0);
            modeIndex = (modeIndex + 1) % MODES.size();
            stack.set(ModDataComponents.EXTEND_MODE, (Object)modeIndex);
            String mode = MODES.get(modeIndex);
            player.displayClientMessage((Component)Component.literal((String)("Extend mode set to: " + mode.replace("_", " "))).withStyle(ChatFormatting.AQUA), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

