/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.ricmc.betterblockz.block.custom.FlatBarLightBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightVerticalBlock;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.RotatableBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class BlockReplacerItem
extends Item {
    public BlockReplacerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Block replacement;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            Direction facing;
            BlockState clickedState = level.getBlockState(pos);
            Block clickedBlock = clickedState.getBlock();
            if (clickedState.hasBlockEntity() || level.getBlockEntity(pos) != null) {
                player.sendSystemMessage((Component)Component.literal((String)"You can\u2019t save this block."));
                level.playSound(null, pos, SoundEvents.VILLAGER_NO, SoundSource.BLOCKS, 1.0f, 0.8f);
                return InteractionResult.FAIL;
            }
            stack.set(ModDataComponents.STORED_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)clickedBlock));
            if (clickedState.getBlock() instanceof RotatableBlock) {
                facing = (Direction)clickedState.getValue((Property)RotatableBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            } else if (clickedState.hasProperty((Property)DirectionalBlock.FACING)) {
                facing = (Direction)clickedState.getValue((Property)DirectionalBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            } else if (clickedState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                facing = (Direction)clickedState.getValue((Property)HorizontalDirectionalBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            } else {
                stack.remove(ModDataComponents.STORED_FACING);
            }
            if (clickedState.hasProperty((Property)RotatedPillarBlock.AXIS)) {
                Direction.Axis axis = (Direction.Axis)clickedState.getValue((Property)RotatedPillarBlock.AXIS);
                stack.set(ModDataComponents.STORED_AXIS, (Object)axis.getName());
            } else {
                stack.remove(ModDataComponents.STORED_AXIS);
            }
            if (clickedBlock instanceof WallOrFloorLightBlock) {
                facing = (Direction)clickedState.getValue((Property)WallOrFloorLightBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            } else if (clickedBlock instanceof LightPanelBlock) {
                facing = (Direction)clickedState.getValue((Property)LightPanelBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            } else if (clickedBlock instanceof FlatBarLightBlock) {
                facing = (Direction)clickedState.getValue((Property)FlatBarLightBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            } else if (clickedBlock instanceof FlatBarLightVerticalBlock) {
                facing = (Direction)clickedState.getValue((Property)FlatBarLightVerticalBlock.FACING);
                stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
            }
            int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            String modeName = switch (mode) {
                case 0 -> "Block Mode";
                case 1 -> "Line Mode";
                case 2 -> "Area Mode";
                default -> "Unknown Mode";
            };
            player.displayClientMessage((Component)Component.literal((String)("Saved block type: " + clickedBlock.getName().getString() + " (" + modeName + ")")), true);
            level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        ResourceLocation storedBlockId = (ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK);
        if (storedBlockId != null && (replacement = (Block)BuiltInRegistries.BLOCK.get(storedBlockId)) != null) {
            int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            BlockState clickedState = level.getBlockState(pos);
            this.applyMode(level, pos, clickedState.getBlock(), mode, face, p -> this.setBlock(level, (BlockPos)p, replacement, player, face), player);
            level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void applyMode(Level level, BlockPos startPos, Block clickedBlock, int mode, Direction face, Function<BlockPos, Boolean> replacer, Player player) {
        boolean didAnyReplace = false;
        boolean didAnyFail = false;
        switch (mode) {
            case 0: {
                if (replacer.apply(startPos).booleanValue()) {
                    didAnyReplace = true;
                    break;
                }
                didAnyFail = true;
                break;
            }
            case 1: {
                didAnyFail |= !this.applyLineMode(level, startPos, clickedBlock, face, replacer, player, 7);
                break;
            }
            case 2: {
                didAnyFail |= !this.applyLineMode(level, startPos, clickedBlock, face, replacer, player, 21);
                break;
            }
            case 3: {
                didAnyFail |= !this.floodFill2D(level, startPos, clickedBlock, face, replacer, 100);
                break;
            }
            case 4: {
                didAnyFail |= !this.floodFill2D(level, startPos, clickedBlock, face, replacer, 500);
            }
        }
        if (!didAnyReplace && didAnyFail) {
            player.displayClientMessage((Component)Component.literal((String)"You don\u2019t have enough blocks!"), true);
        }
    }

    private boolean applyLineMode(Level level, BlockPos startPos, Block clickedBlock, Direction face, Function<BlockPos, Boolean> replacer, Player player, int length) {
        Direction lineDir = face.getAxis().isHorizontal() ? (player.getViewXRot(1.0f) < -30.0f ? Direction.UP : (player.getViewXRot(1.0f) > 30.0f ? Direction.DOWN : player.getDirection().getCounterClockWise())) : player.getDirection();
        boolean didAnyReplace = false;
        boolean didAnyFail = false;
        for (int i = 0; i < length; ++i) {
            BlockPos pos = startPos.relative(lineDir, i);
            Block blockAtPos = level.getBlockState(pos).getBlock();
            if (blockAtPos != clickedBlock) continue;
            if (replacer.apply(pos).booleanValue()) {
                didAnyReplace = true;
                continue;
            }
            didAnyFail = true;
        }
        return didAnyReplace || !didAnyFail;
    }

    private boolean floodFill2D(Level level, BlockPos startPos, Block targetBlock, Direction face, Function<BlockPos, Boolean> replacer, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        boolean didAnyReplace = false;
        boolean didAnyFail = false;
        queue.add(startPos);
        visited.add(startPos);
        List<BlockPos> offsets = face == Direction.UP || face == Direction.DOWN ? List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1)) : (face.getAxis() == Direction.Axis.X ? List.of(new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(0, 1, 1), new BlockPos(0, 1, -1), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1)) : List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(1, 1, 0), new BlockPos(1, -1, 0), new BlockPos(-1, 1, 0), new BlockPos(-1, -1, 0)));
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            Block blockAtPos = level.getBlockState(current).getBlock();
            if (blockAtPos != targetBlock) continue;
            boolean blocked = false;
            if (face == Direction.UP) {
                blocked = !level.getBlockState(current.above()).isAir();
            } else if (face == Direction.DOWN) {
                blocked = !level.getBlockState(current.below()).isAir();
            } else {
                BlockPos inFront = current.relative(face);
                boolean bl = blocked = !level.getBlockState(inFront).isAir();
            }
            if (blocked) continue;
            if (replacer.apply(current).booleanValue()) {
                didAnyReplace = true;
            } else {
                didAnyFail = true;
            }
            for (BlockPos offset : offsets) {
                Block neighborBlock;
                BlockPos neighbor = current.offset((Vec3i)offset);
                if (visited.contains(neighbor) || !level.isLoaded(neighbor) || (neighborBlock = level.getBlockState(neighbor).getBlock()) != targetBlock) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return didAnyReplace || !didAnyFail;
    }

    private boolean setBlock(Level level, BlockPos pos, Block replacement, Player player, Direction clickedFace) {
        ItemStack stack = player.getMainHandItem();
        BlockState currentState = level.getBlockState(pos);
        if (currentState.getBlock() == replacement) {
            return true;
        }
        if (level.getBlockEntity(pos) != null) {
            return false;
        }
        BlockState newState = replacement.defaultBlockState();
        newState = this.applyOrientation(newState, stack, clickedFace);
        if (player.isCreative()) {
            level.setBlockAndUpdate(pos, newState);
            return true;
        }
        if (!this.removeBlockFromInventory(player, replacement)) {
            return false;
        }
        List drops = Block.getDrops((BlockState)currentState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
        level.destroyBlock(pos, false, (Entity)player);
        for (ItemStack drop : drops) {
            if (player.getInventory().add(drop)) continue;
            player.drop(drop, false);
        }
        level.setBlockAndUpdate(pos, newState);
        return true;
    }

    private BlockState applyOrientation(BlockState state, ItemStack stack, Direction clickedFace) {
        Direction facing;
        String savedFacing;
        if (state.getBlock() instanceof RotatableBlock) {
            Direction facing2;
            String savedFacing2 = (String)stack.get(ModDataComponents.STORED_FACING);
            Direction direction = savedFacing2 != null ? Direction.byName((String)savedFacing2) : (facing2 = clickedFace.getAxis().isVertical() ? Direction.NORTH : clickedFace.getOpposite());
            if (facing2 != null && state.hasProperty((Property)RotatableBlock.FACING)) {
                state = (BlockState)state.setValue((Property)RotatableBlock.FACING, (Comparable)facing2);
            }
            return state;
        }
        if (state.hasProperty((Property)RotatedPillarBlock.AXIS)) {
            Direction.Axis axis;
            String savedAxis = (String)stack.get(ModDataComponents.STORED_AXIS);
            Direction.Axis axis2 = axis = savedAxis != null ? Direction.Axis.byName((String)savedAxis) : clickedFace.getAxis();
            if (axis != null) {
                state = (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis);
            }
        }
        if (state.hasProperty((Property)DirectionalBlock.FACING)) {
            savedFacing = (String)stack.get(ModDataComponents.STORED_FACING);
            Direction direction = savedFacing != null ? Direction.byName((String)savedFacing) : (facing = clickedFace.getAxis().isVertical() ? Direction.NORTH : clickedFace.getOpposite());
            assert (facing != null);
            state = (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)facing);
        }
        if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            savedFacing = (String)stack.get(ModDataComponents.STORED_FACING);
            Direction direction = savedFacing != null ? Direction.byName((String)savedFacing) : (facing = clickedFace.getAxis().isVertical() ? Direction.NORTH : clickedFace.getOpposite());
            assert (facing != null);
            state = (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing);
        }
        if (state.getBlock() instanceof WallOrFloorLightBlock) {
            savedFacing = (String)stack.get(ModDataComponents.STORED_FACING);
            if (savedFacing != null && (facing = Direction.byName((String)savedFacing)) != null && state.hasProperty((Property)WallOrFloorLightBlock.FACING)) {
                state = (BlockState)state.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)facing);
            }
        } else if (state.getBlock() instanceof LightPanelBlock) {
            savedFacing = (String)stack.get(ModDataComponents.STORED_FACING);
            if (savedFacing != null && (facing = Direction.byName((String)savedFacing)) != null && state.hasProperty((Property)LightPanelBlock.FACING)) {
                state = (BlockState)state.setValue((Property)LightPanelBlock.FACING, (Comparable)facing);
            }
        } else if (state.getBlock() instanceof FlatBarLightBlock) {
            savedFacing = (String)stack.get(ModDataComponents.STORED_FACING);
            if (savedFacing != null && (facing = Direction.byName((String)savedFacing)) != null && state.hasProperty((Property)FlatBarLightBlock.FACING)) {
                state = (BlockState)state.setValue((Property)FlatBarLightBlock.FACING, (Comparable)facing);
            }
        } else if (state.getBlock() instanceof FlatBarLightVerticalBlock && (savedFacing = (String)stack.get(ModDataComponents.STORED_FACING)) != null && (facing = Direction.byName((String)savedFacing)) != null && state.hasProperty((Property)FlatBarLightVerticalBlock.FACING)) {
            state = (BlockState)state.setValue((Property)FlatBarLightVerticalBlock.FACING, (Comparable)facing);
        }
        return state;
    }

    private BlockState copyOrientation(BlockState fromState, BlockState toState) {
        for (Property prop : fromState.getProperties()) {
            String name = prop.getName();
            if (!name.equals("facing") && !name.equals("axis") && !name.equals("half") && !name.equals("rotation") || !toState.hasProperty(prop)) continue;
            try {
                toState = (BlockState)toState.setValue(prop, fromState.getValue(prop));
            }
            catch (Exception exception) {}
        }
        return toState;
    }

    private boolean removeBlockFromInventory(Player player, Block block) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(block.asItem())) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            int nextMode = (currentMode + 1) % 5;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = switch (nextMode) {
                case 0 -> "Block Mode";
                case 1 -> "Line Mode (7)";
                case 2 -> "Line Mode (21)";
                case 3 -> "Area Mode Small";
                case 4 -> "Area Mode Large";
                default -> "";
            };
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

