/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.client;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlock;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotSmallBlock;
import com.davenonymous.bonsaitrees.client.PotModel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockFakeLevel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModel;
import com.davenonymous.bonsaitrees.lib.util.EasingFunction;
import com.davenonymous.bonsaitrees.setup.ModModelLoaders;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BonsaiPotBlockRenderer
implements BlockEntityRenderer<BonsaiPotBlockEntity> {
    public BonsaiPotBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BonsaiPotBlockEntity pPotBlock, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        BakedModel potModel = modelManager.getBlockModelShaper().getBlockModel(pPotBlock.getBlockState());
        Vec3 treeOffset = new Vec3(0.0, 0.0, 0.0);
        float treeMaxScale = 1.0f;
        if (potModel instanceof PotModel) {
            PotModel pot = (PotModel)potModel;
            treeOffset = pot.treeOffset;
            treeMaxScale = pot.treeScale;
        }
        float progress = pPotBlock.getTreeGrowthProgress(pPartialTick);
        EasingFunction easingFunction = pPotBlock.getBlockState().getBlock() instanceof BonsaiPotSmallBlock ? EasingFunction.chained(EasingFunction.easeInOutCubic(), EasingFunction.easeInOutCubic(), EasingFunction.easeInOutCubic()) : EasingFunction.easeInOutSquare();
        float scale = (float)easingFunction.apply(progress);
        ModelData modelData = pPotBlock.getModelData();
        ResourceLocation saplingId = (ResourceLocation)modelData.get(BonsaiPotBlock.SAPLING);
        if (saplingId != null && ModModelLoaders.MODEL_MAP.containsKey(saplingId)) {
            MultiBlockFakeLevel level;
            MultiBlockModel multiBlockModel;
            VertexBuffer vertexBuffer;
            ModelResourceLocation model = ModModelLoaders.MODEL_MAP.get(saplingId);
            BakedModel bakedModel = Minecraft.getInstance().getModelManager().getModel(model);
            if (bakedModel instanceof MultiBlockModel && (vertexBuffer = ModModelLoaders.getVbo(saplingId, multiBlockModel = (MultiBlockModel)bakedModel, level = new MultiBlockFakeLevel(multiBlockModel, (BlockAndTintGetter)pPotBlock.getLevel(), pPotBlock.getBlockPos()), pPotBlock.getBlockPos())) != null && !vertexBuffer.isInvalid()) {
                vertexBuffer.bind();
                poseStack.pushPose();
                poseStack.translate(treeOffset.x / 16.0, treeOffset.y / 16.0, treeOffset.z / 16.0);
                poseStack.scale(treeMaxScale, treeMaxScale, treeMaxScale);
                poseStack.scale(scale, scale, scale);
                Matrix4f modelMatrix = poseStack.last().pose();
                Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
                viewMatrix.mul((Matrix4fc)modelMatrix);
                ModModelLoaders.renderTypeForModels.setupRenderState();
                ShaderInstance shader = RenderSystem.getShader();
                shader.setDefaultUniforms(VertexFormat.Mode.QUADS, viewMatrix, RenderSystem.getProjectionMatrix(), Minecraft.getInstance().getWindow());
                Level potLevel = pPotBlock.getLevel();
                float sunBrightness = 1.0f - ((ClientLevel)potLevel).getStarBrightness(pPartialTick);
                int skyLight = pPackedLight >> 20 & 0xF;
                int blockLight = pPackedLight >> 4 & 0xF;
                float skyBrightness = (float)skyLight / 15.0f;
                float blockBrightness = (float)blockLight / 15.0f;
                float sunReceivedLight = sunBrightness * skyBrightness;
                float brighterBrightness = Math.max(sunReceivedLight, blockBrightness);
                float lightLevel = Math.clamp(brighterBrightness, 0.1f, 0.9f);
                RenderSystem.setShaderColor((float)lightLevel, (float)lightLevel, (float)lightLevel, (float)1.0f);
                RenderSystem.setupShaderLights((ShaderInstance)shader);
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
                Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
                vertexBuffer.drawWithShader(viewMatrix, projectionMatrix, shader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VertexBuffer.unbind();
                poseStack.popPose();
            }
        }
    }
}

