/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockFakeLevel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModel;
import com.davenonymous.bonsaitrees.setup.ModModelLoaders;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;

public class MultiBlockModelTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final ResourceLocation modelId;
    private final MultiBlockModel multiBlockModel;
    private final int width;
    private final int height;

    public MultiBlockModelTooltipComponent(ResourceLocation modelId, int width, int height) {
        this.modelId = modelId;
        if (ModModelLoaders.MODEL_MAP.containsKey(modelId)) {
            ModelResourceLocation treeModelId = ModModelLoaders.MODEL_MAP.get(modelId);
            BakedModel model = Minecraft.getInstance().getModelManager().getModel(treeModelId);
            if (!(model instanceof MultiBlockModel)) {
                this.multiBlockModel = null;
                this.width = 0;
                this.height = 0;
                return;
            }
            this.multiBlockModel = (MultiBlockModel)Minecraft.getInstance().getModelManager().getModel(treeModelId);
            this.width = width;
            this.height = height;
        } else {
            this.multiBlockModel = null;
            this.width = 0;
            this.height = 0;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth(Font font) {
        return this.width;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.multiBlockModel == null) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 100.0f);
        guiGraphics.pose().translate((float)this.width / 2.0f, (float)(this.height - 8), 0.0f);
        guiGraphics.pose().scale(32.0f, 32.0f, 32.0f);
        guiGraphics.pose().mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(155.0), 1.0f, 0.0f, 0.0f)));
        long gameTicks = Minecraft.getInstance().level.getGameTime();
        float foo = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        guiGraphics.pose().mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians((double)gameTicks + (double)foo), 0.0f, 1.0f, 0.0f)));
        MultiBlockFakeLevel fakeLevel = new MultiBlockFakeLevel(this.multiBlockModel, (BlockAndTintGetter)Minecraft.getInstance().level, BlockPos.ZERO);
        VertexBuffer treeVbo = ModModelLoaders.getVbo(this.modelId, this.multiBlockModel, fakeLevel, BlockPos.ZERO);
        if (treeVbo != null && !treeVbo.isInvalid()) {
            Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
            viewMatrix.mul((Matrix4fc)guiGraphics.pose().last().pose());
            ModModelLoaders.renderTypeForModels.setupRenderState();
            ShaderInstance shader = RenderSystem.getShader();
            shader.setDefaultUniforms(VertexFormat.Mode.QUADS, viewMatrix, projectionMatrix, Minecraft.getInstance().getWindow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setupShaderLights((ShaderInstance)shader);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            treeVbo.bind();
            GL11.glFrontFace((int)2304);
            treeVbo.drawWithShader(viewMatrix, projectionMatrix, shader);
            GL11.glFrontFace((int)2305);
            VertexBuffer.unbind();
        }
        guiGraphics.pose().popPose();
    }
}

