/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import dan200.computercraft.api.client.turtle.RegisterTurtleUpgradeModeller;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.client.gui.ComputerScreen;
import dan200.computercraft.client.gui.DiskDriveScreen;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.gui.PrinterScreen;
import dan200.computercraft.client.gui.PrintoutScreen;
import dan200.computercraft.client.gui.TurtleScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.CustomLecternRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.turtle.TurtleModemModeller;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.io.function.IOSupplier;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRegistry.class);
    private static final ResourceLocation[] EXTRA_MODELS = new ResourceLocation[]{TurtleOverlay.ELF_MODEL, TurtleBlockEntityRenderer.COLOUR_TURTLE_MODEL};

    private ClientRegistry() {
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.MONITOR_NORMAL.get()), MonitorBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.MONITOR_ADVANCED.get()), MonitorBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.TURTLE_NORMAL.get()), TurtleBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.TURTLE_ADVANCED.get()), TurtleBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.LECTERN.get()), CustomLecternRenderer::new);
    }

    public static void registerMainThread(RegisterItemProperty itemProperties) {
        ClientRegistry.registerItemProperty(itemProperties, "state", new UnclampedPropertyFunction((stack, world, player, random) -> {
            PocketComputerData computer = ClientPocketComputers.get(stack);
            return (computer == null ? ComputerState.OFF : computer.getState()).ordinal();
        }), ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
        ClientRegistry.registerItemProperty(itemProperties, "coloured", (stack, world, player, random) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)-1) != -1 ? 1.0f : 0.0f, ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
    }

    public static void registerMenuScreens(RegisterMenuScreen register) {
        register.register((MenuType)ModRegistry.Menus.COMPUTER.get(), ComputerScreen::new);
        register.register((MenuType)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get(), NoTermComputerScreen::new);
        register.register((MenuType)ModRegistry.Menus.TURTLE.get(), TurtleScreen::new);
        register.register((MenuType)ModRegistry.Menus.PRINTER.get(), PrinterScreen::new);
        register.register((MenuType)ModRegistry.Menus.DISK_DRIVE.get(), DiskDriveScreen::new);
        register.register((MenuType)ModRegistry.Menus.PRINTOUT.get(), PrintoutScreen::new);
    }

    public static void registerTurtleModellers(RegisterTurtleUpgradeModeller register) {
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.SPEAKER.get(), TurtleUpgradeModeller.sided(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_speaker_left"), ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_speaker_right")));
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.WORKBENCH.get(), TurtleUpgradeModeller.sided(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_crafting_table_left"), ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_crafting_table_right")));
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.WIRELESS_MODEM.get(), new TurtleModemModeller());
        register.register((UpgradeType)ModRegistry.TurtleUpgradeTypes.TOOL.get(), TurtleUpgradeModeller.flatItem());
    }

    @SafeVarargs
    private static void registerItemProperty(RegisterItemProperty itemProperties, String name, ClampedItemPropertyFunction getter, Supplier<? extends Item> ... items) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)name);
        for (Supplier<? extends Item> item : items) {
            itemProperties.register(item.get(), id, getter);
        }
    }

    public static void registerExtraModels(Consumer<ResourceLocation> register, Collection<ResourceLocation> extraModels) {
        for (ResourceLocation model : EXTRA_MODELS) {
            register.accept(model);
        }
        extraModels.forEach(register);
        TurtleUpgradeModellers.getDependencies().forEach(register);
    }

    public static void registerItemColours(BiConsumer<ItemColor, ItemLike> register) {
        register.accept((stack, layer) -> layer == 1 ? DyedItemColor.getOrDefault((ItemStack)stack, (int)Colour.WHITE.getARGB()) : -1, (ItemLike)ModRegistry.Items.DISK.get());
        register.accept((stack, layer) -> layer == 1 ? DyedItemColor.getOrDefault((ItemStack)stack, (int)Colour.BLUE.getARGB()) : -1, (ItemLike)ModRegistry.Items.TREASURE_DISK.get());
        register.accept(ClientRegistry::getPocketColour, (ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get());
        register.accept(ClientRegistry::getPocketColour, (ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
        register.accept(ClientRegistry::getTurtleColour, (ItemLike)ModRegistry.Blocks.TURTLE_NORMAL.get());
        register.accept(ClientRegistry::getTurtleColour, (ItemLike)ModRegistry.Blocks.TURTLE_ADVANCED.get());
    }

    private static int getPocketColour(ItemStack stack, int layer) {
        return switch (layer) {
            default -> -1;
            case 1 -> DyedItemColor.getOrDefault((ItemStack)stack, (int)-1);
            case 2 -> {
                PocketComputerData computer = ClientPocketComputers.get(stack);
                if (computer == null || computer.getLightState() == -1) {
                    yield Colour.BLACK.getARGB();
                }
                yield FastColor.ARGB32.opaque((int)computer.getLightState());
            }
        };
    }

    private static int getTurtleColour(ItemStack stack, int layer) {
        return layer == 0 ? DyedItemColor.getOrDefault((ItemStack)stack, (int)-1) : -1;
    }

    public static void registerShaders(ResourceProvider resources, BiConsumer<ShaderInstance, Consumer<ShaderInstance>> load) throws IOException {
        RenderTypes.registerShaders(resources, (String name, IOSupplier<ShaderInstance> create, Consumer<ShaderInstance> onLoaded) -> {
            ShaderInstance shader;
            try {
                shader = (ShaderInstance)create.get();
            }
            catch (Exception e) {
                LOG.error("Failed to load {}", (Object)name, (Object)e);
                onLoaded.accept(null);
                return;
            }
            load.accept(shader, onLoaded);
        });
    }

    public static <T> void registerClientCommands(CommandDispatcher<T> dispatcher, BiConsumer<T, Component> sendError) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"computercraft-computer-folder").requires(x -> Minecraft.getInstance().getSingleplayerServer() != null)).then(RequiredArgumentBuilder.argument((String)"computer_id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> ClientRegistry.handleOpenComputerCommand(c.getSource(), sendError, (Integer)c.getArgument("computer_id", Integer.class)))));
    }

    private static <T> int handleOpenComputerCommand(T context, BiConsumer<T, Component> sendError, int id) {
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        if (server == null) {
            sendError.accept(context, (Component)Component.literal((String)"Not on a single-player server"));
            return 0;
        }
        File file = new File(ServerContext.get((MinecraftServer)server).storageDir().toFile(), "computer/" + id);
        if (!file.isDirectory()) {
            sendError.accept(context, (Component)Component.literal((String)"Computer's folder does not exist"));
            return 0;
        }
        Util.getPlatform().openFile(file);
        return 1;
    }

    private record UnclampedPropertyFunction(ClampedItemPropertyFunction function) implements ClampedItemPropertyFunction
    {
        public float unclampedCall(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int layer) {
            return this.function.unclampedCall(stack, level, entity, layer);
        }

        @Deprecated
        public float call(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int layer) {
            return this.function.unclampedCall(stack, level, entity, layer);
        }
    }

    public static interface RegisterItemProperty {
        public void register(Item var1, ResourceLocation var2, ClampedItemPropertyFunction var3);
    }

    public static interface RegisterMenuScreen {
        public <M extends AbstractContainerMenu, U extends Screen> void register(MenuType<? extends M> var1, MenuScreens.ScreenConstructor<M, U> var2);
    }
}

