/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockItem;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class CableBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<CableModemVariant> MODEM = EnumProperty.create((String)"modem", CableModemVariant.class);
    public static final BooleanProperty CABLE = BooleanProperty.create((String)"cable");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    static final EnumMap<Direction, BooleanProperty> CONNECTIONS = (EnumMap)Util.make(new EnumMap(Direction.class), m -> {
        m.put(Direction.DOWN, DOWN);
        m.put(Direction.UP, UP);
        m.put(Direction.NORTH, NORTH);
        m.put(Direction.SOUTH, SOUTH);
        m.put(Direction.WEST, WEST);
        m.put(Direction.EAST, EAST);
    });

    public CableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(MODEM, (Comparable)((Object)CableModemVariant.None))).setValue((Property)CABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MODEM, CABLE, NORTH, SOUTH, EAST, WEST, UP, DOWN, WaterloggableHelpers.WATERLOGGED});
    }

    public static boolean canConnectIn(BlockState state, Direction direction) {
        return (Boolean)state.getValue((Property)CABLE) != false && ((CableModemVariant)((Object)state.getValue(MODEM))).getFacing() != direction;
    }

    public static boolean doesConnectVisually(BlockState state, Level level, BlockPos pos, Direction direction) {
        if (!((Boolean)state.getValue((Property)CABLE)).booleanValue()) {
            return false;
        }
        if (((CableModemVariant)((Object)state.getValue(MODEM))).getFacing() == direction) {
            return true;
        }
        return PlatformHelper.get().hasWiredElementIn(level, pos, direction);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CableShapes.getShape(state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.playerWillDestroy(world, pos, state, player);
        if (this.onCustomDestroyBlock(state, world, pos, player)) {
            return false;
        }
        return world.setBlock(pos, fluid.createLegacyBlock(), world.isClientSide ? 11 : 3);
    }

    public boolean onCustomDestroyBlock(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack item;
        BlockState newState;
        CableBlockEntity cable;
        BlockHitResult hit;
        block9: {
            block8: {
                if (!((Boolean)state.getValue((Property)CABLE)).booleanValue() || ((CableModemVariant)((Object)state.getValue(MODEM))).getFacing() == null) {
                    return false;
                }
                hit = world.clip(new ClipContext(WorldUtil.getRayStart(player), WorldUtil.getRayEnd(player), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                if (hit.getType() != HitResult.Type.BLOCK) {
                    return false;
                }
                BlockEntity tile = world.getBlockEntity(pos);
                if (!(tile instanceof CableBlockEntity)) break block8;
                cable = (CableBlockEntity)tile;
                if (tile.hasLevel()) break block9;
            }
            return false;
        }
        if (WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))) {
            newState = (BlockState)state.setValue(MODEM, (Comparable)((Object)CableModemVariant.None));
            item = new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get());
        } else {
            newState = (BlockState)state.setValue((Property)CABLE, (Comparable)Boolean.valueOf(false));
            item = new ItemStack((ItemLike)ModRegistry.Items.CABLE.get());
        }
        world.setBlockAndUpdate(pos, CableBlock.correctConnections(world, pos, newState));
        cable.connectionsChanged();
        if (!world.isClientSide && !player.getAbilities().instabuild) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)item);
        }
        return true;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)CABLE) != false ? new ItemStack((ItemLike)ModRegistry.Items.CABLE.get()) : new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get());
    }

    public ItemStack getCloneItemStack(BlockState state, @Nullable HitResult hit, LevelReader world, BlockPos pos, Player player) {
        Direction modem = ((CableModemVariant)((Object)state.getValue(MODEM))).getFacing();
        boolean cable = (Boolean)state.getValue((Property)CABLE);
        if (!cable) {
            return new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get());
        }
        if (modem == null) {
            return new ItemStack((ItemLike)ModRegistry.Items.CABLE.get());
        }
        return hit != null && WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) ? new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get()) : new ItemStack((ItemLike)ModRegistry.Items.CABLE.get());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CableBlockEntity cable;
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof CableBlockEntity && (cable = (CableBlockEntity)tile).hasCable()) {
            cable.connectionsChanged();
        }
        super.setPlacedBy(world, pos, state, placer, stack);
    }

    protected FluidState getFluidState(BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction side, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        BlockState blockState;
        BlockEntity blockEntity;
        CableModemVariant modem;
        WaterloggableHelpers.updateShape(state, level, pos);
        if (!((Boolean)state.getValue((Property)CABLE)).booleanValue() && state.getValue(MODEM) == CableModemVariant.None) {
            return this.getFluidState(state).createLegacyBlock();
        }
        Direction dir = ((CableModemVariant)((Object)state.getValue(MODEM))).getFacing();
        if (dir != null && dir.equals((Object)side) && !ModemShapes.canSupport((LevelReader)level, otherPos, side.getOpposite())) {
            BlockEntity blockEntity2;
            if (!((Boolean)state.getValue((Property)CABLE)).booleanValue()) {
                return this.getFluidState(state).createLegacyBlock();
            }
            state = (BlockState)state.setValue(MODEM, (Comparable)((Object)CableModemVariant.None));
            if (level instanceof Level) {
                Level actualLevel = (Level)level;
                Block.popResource((Level)actualLevel, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get()));
            }
            if ((blockEntity2 = level.getBlockEntity(pos)) instanceof CableBlockEntity) {
                CableBlockEntity cable = (CableBlockEntity)blockEntity2;
                cable.scheduleConnectionsChanged();
            }
        }
        if ((modem = (CableModemVariant)((Object)state.getValue(MODEM))).getFacing() == side && modem.isPeripheralOn() && (blockEntity = level.getBlockEntity(pos)) instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)blockEntity;
            cable.queueRefreshPeripheral();
        }
        if (level instanceof Level) {
            Level actualLevel = (Level)level;
            blockState = (BlockState)state.setValue((Property)CONNECTIONS.get(side), (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, actualLevel, pos, side)));
        } else {
            blockState = state;
        }
        return blockState;
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = ((CableModemVariant)((Object)state.getValue(MODEM))).getFacing();
        if (facing == null) {
            return true;
        }
        return ModemShapes.canSupport(world, pos.relative(facing), facing.getOpposite());
    }

    public @Nullable BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(context)));
        if (context.getItemInHand().getItem() instanceof CableBlockItem.Cable) {
            Level world = context.getLevel();
            BlockPos pos = context.getClickedPos();
            return CableBlock.correctConnections(world, pos, (BlockState)state.setValue((Property)CABLE, (Comparable)Boolean.valueOf(true)));
        }
        return (BlockState)state.setValue(MODEM, (Comparable)((Object)CableModemVariant.from(context.getClickedFace().getOpposite())));
    }

    public static BlockState correctConnections(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)CABLE)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.WEST)))).setValue((Property)UP, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.DOWN)));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }

    protected final InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult interactionResult;
        if (player.isCrouching() || !player.mayBuild()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            interactionResult = modem.use(player);
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    protected final void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            modem.neighborChanged(neighbourPos);
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            modem.blockTick();
        }
    }

    public @Nullable BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModRegistry.BlockEntities.CABLE.get()).create(pos, state);
    }
}

