/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.integration.jei;

import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.carving.CarvingGroup;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;

@EventBusSubscriber(modid="chisel", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class CraftableBlockCache {
    private static final Map<ResourceLocation, ItemStack> CACHE = new HashMap<ResourceLocation, ItemStack>();

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        CraftableBlockCache.rebuild(event.getRecipeManager());
    }

    private static void rebuild(RecipeManager recipeManager) {
        CACHE.clear();
        HashSet craftableItems = new HashSet();
        for (RecipeHolder recipeHolder : recipeManager.getRecipes()) {
            ItemStack result;
            if (!(recipeHolder.value() instanceof CraftingRecipe) && !(recipeHolder.value() instanceof SmeltingRecipe) || (result = recipeHolder.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())).isEmpty()) continue;
            result.getItemHolder().unwrapKey().ifPresent(key -> craftableItems.add(key.location()));
        }
        block1: for (ChiselBlockType chiselBlockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            CarvingGroup group = new CarvingGroup(chiselBlockType);
            ResourceLocation groupId = group.getId();
            List<Item> groupItems = CarvingHelper.getItemsInGroup(group.getItemTag());
            for (Item item : groupItems) {
                ResourceLocation itemId = item.builtInRegistryHolder().key().location();
                if (!craftableItems.contains(itemId)) continue;
                CACHE.put(groupId, new ItemStack((ItemLike)item));
                continue block1;
            }
        }
    }

    public static ItemStack get(ResourceLocation groupId) {
        return CACHE.getOrDefault(groupId, ItemStack.EMPTY);
    }
}

