/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.leclowndu93150.chisel.api.chunkdata.ChunkData;
import com.leclowndu93150.chisel.api.chunkdata.OffsetData;
import com.leclowndu93150.chisel.network.ChunkDataPayload;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemOffsetTool
extends Item {
    private static final int MAX_CONNECTED_BLOCKS = 512;

    public ItemOffsetTool(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        ChunkPos chunkPos;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockState clickedState = world.getBlockState(pos);
        Block clickedBlock = clickedState.getBlock();
        Set<BlockPos> connectedBlocks = this.findConnectedBlocks(world, pos, clickedBlock);
        Vec3 hitVec = context.getClickLocation();
        Direction moveDir = this.getMoveDir(context.getClickedFace(), hitVec.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        HashMap<ChunkPos, Set> blocksByChunk = new HashMap<ChunkPos, Set>();
        for (BlockPos blockPos : connectedBlocks) {
            chunkPos = new ChunkPos(blockPos);
            blocksByChunk.computeIfAbsent(chunkPos, k -> new HashSet()).add(blockPos);
        }
        for (Map.Entry entry : blocksByChunk.entrySet()) {
            chunkPos = (ChunkPos)entry.getKey();
            Set blocksInChunk = (Set)entry.getValue();
            OffsetData data = ChunkData.getOrCreateData(world, chunkPos);
            data.moveAll(blocksInChunk, moveDir);
            LevelChunk chunk = world.getChunk(chunkPos.x, chunkPos.z);
            chunk.setUnsaved(true);
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)world;
            CompoundTag tag = new CompoundTag();
            data.writeToNBT(tag);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)new ChunkDataPayload(chunkPos.x, chunkPos.z, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResult.SUCCESS;
    }

    private Set<BlockPos> findConnectedBlocks(Level world, BlockPos start, Block targetBlock) {
        HashSet<BlockPos> connected = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(start);
        connected.add(start);
        while (!toCheck.isEmpty() && connected.size() < 512) {
            BlockPos current = (BlockPos)toCheck.poll();
            for (Direction dir : Direction.values()) {
                BlockState neighborState;
                BlockPos neighbor = current.relative(dir);
                if (connected.contains(neighbor) || (neighborState = world.getBlockState(neighbor)).getBlock() != targetBlock) continue;
                connected.add(neighbor);
                toCheck.add(neighbor);
            }
        }
        return connected;
    }

    public Direction getMoveDir(Direction face, Vec3 hitVec) {
        HashMap map = Maps.newHashMap();
        if (face.getStepX() != 0) {
            this.fillMap(map, hitVec.z - (double)((int)hitVec.z), hitVec.y - (double)((int)hitVec.y), Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH);
        } else if (face.getStepY() != 0) {
            this.fillMap(map, hitVec.x - (double)((int)hitVec.x), hitVec.z - (double)((int)hitVec.z), Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
        } else if (face.getStepZ() != 0) {
            this.fillMap(map, hitVec.x - (double)((int)hitVec.x), hitVec.y - (double)((int)hitVec.y), Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
        }
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort(keys);
        return (Direction)map.get(keys.get(0));
    }

    private void fillMap(Map<Double, Direction> map, double x, double y, Direction ... dirs) {
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 1.0, 0.0, x, y), dirs[0]);
        map.put(Line2D.ptLineDistSq(0.0, 1.0, 1.0, 1.0, x, y), dirs[1]);
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 0.0, 1.0, x, y), dirs[2]);
        map.put(Line2D.ptLineDistSq(1.0, 0.0, 1.0, 1.0, x, y), dirs[3]);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"chisel.tooltip.offset_tool.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"chisel.tooltip.offset_tool.2").withStyle(ChatFormatting.GRAY));
    }
}

