/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import com.mojang.serialization.DynamicOps;
import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidPipeEntity
extends PipeEntity {
    public static final int CAPACITY = 1000;
    public static final int MIN_PACKET_SIZE = 20;
    private static final float MAX_RENDER_WIDTH_CHANGE = 0.015625f;
    protected Fluid fluid;
    protected final List<FluidInPipe> contents;
    protected final List<FluidInPipe> queued;
    private final Map<FluidInPipe, Long> tickAdded;
    public float targetRenderWidth;
    public float lastRenderWidth;
    public boolean[] skipRenderingSide = new boolean[6];

    public FluidPipeEntity(BlockPos pos, BlockState state) {
        this(ClassicPipes.FLUID_PIPE_ENTITY, pos, state);
    }

    public FluidPipeEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.contents = new ArrayList<FluidInPipe>();
        this.queued = new ArrayList<FluidInPipe>();
        this.tickAdded = new HashMap<FluidInPipe, Long>();
        this.fluid = Fluids.WATER;
        Arrays.fill(this.skipRenderingSide, true);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        boolean sendBlockUpdate = false;
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = iterator.next();
                if (this.tickAdded.containsKey(fluidPacket)) {
                    if (this.tickAdded.get(fluidPacket).longValue() == level.getGameTime()) continue;
                    this.tickAdded.remove(fluidPacket);
                }
                fluidPacket.move(this.getTargetSpeed(), this.getAcceleration());
                if (fluidPacket.getAge() > 24000) {
                    iterator.remove();
                    sendBlockUpdate = true;
                    continue;
                }
                if (fluidPacket.getProgress() < 2048) continue;
                boolean remove = false;
                BlockPos containerPos = pos.relative(fluidPacket.getTargetDirection());
                BlockEntity blockEntity = level.getBlockEntity(containerPos);
                if (blockEntity instanceof FluidPipeEntity) {
                    FluidPipeEntity nextPipe = (FluidPipeEntity)blockEntity;
                    if (nextPipe.emptyOrMatches(this.fluid)) {
                        nextPipe.setFluid(this.fluid);
                        remove = true;
                        int amountToPass = Math.min(fluidPacket.getAmount(), nextPipe.remainingCapacity());
                        if (amountToPass == fluidPacket.getAmount()) {
                            fluidPacket.resetProgress(fluidPacket.getTargetDirection().getOpposite());
                            nextPipe.insertFluidPacket((Level)level, fluidPacket);
                        } else {
                            remove = false;
                            if (amountToPass >= 20) {
                                FluidInPipe newPacket = fluidPacket.copyWithAmount(amountToPass);
                                newPacket.resetProgress(fluidPacket.getTargetDirection().getOpposite());
                                nextPipe.insertFluidPacket((Level)level, newPacket);
                                fluidPacket.setAmount(fluidPacket.getAmount() - amountToPass);
                            }
                        }
                        level.sendBlockUpdated(containerPos, nextPipe.getBlockState(), nextPipe.getBlockState(), 2);
                    }
                } else if (blockEntity != null) {
                    remove = Services.LOADER_SERVICE.handleFluidInsertion(this, level, pos, state, blockEntity, containerPos, this.fluid, fluidPacket);
                }
                if (remove) {
                    iterator.remove();
                } else {
                    fluidPacket.resetProgress(fluidPacket.getTargetDirection());
                    this.routePacket(state, fluidPacket);
                }
                sendBlockUpdate = true;
            }
            this.addQueuedPackets((Level)level, false);
        }
        if (sendBlockUpdate) {
            level.sendBlockUpdated(pos, state, state, 2);
        }
    }

    @Override
    public void tickClient(Level level, BlockPos pos) {
        this.lastRenderWidth = this.targetRenderWidth;
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            int totalAmount = 0;
            Arrays.fill(this.skipRenderingSide, true);
            while (iterator.hasNext()) {
                FluidPipeEntity nextPipe;
                BlockPos nextPos;
                BlockEntity blockEntity;
                FluidInPipe fluidPacket = iterator.next();
                totalAmount += fluidPacket.getAmount();
                this.skipRenderingSide[fluidPacket.getTargetDirection().get3DDataValue()] = false;
                this.skipRenderingSide[fluidPacket.getFromDirection().get3DDataValue()] = false;
                if (this.tickAdded.containsKey(fluidPacket)) {
                    if (this.tickAdded.get(fluidPacket).longValue() == level.getGameTime()) continue;
                    this.tickAdded.remove(fluidPacket);
                }
                fluidPacket.move(this.getTargetSpeed(), this.getAcceleration());
                if (fluidPacket.getProgress() < 2048 || !((blockEntity = level.getBlockEntity(nextPos = pos.relative(fluidPacket.getTargetDirection()))) instanceof FluidPipeEntity) || !(nextPipe = (FluidPipeEntity)blockEntity).emptyOrMatches(this.fluid)) continue;
                fluidPacket.resetProgress(fluidPacket.getTargetDirection().getOpposite());
                nextPipe.setFluid(this.fluid);
                nextPipe.insertFluidPacket(level, fluidPacket);
                iterator.remove();
            }
            this.targetRenderWidth = Math.min(1.0f, (float)Math.sqrt(totalAmount) / (float)Math.sqrt(1000.0)) * 0.4375f;
        } else {
            this.targetRenderWidth = 0.0f;
        }
        this.targetRenderWidth = Math.clamp(this.targetRenderWidth, this.lastRenderWidth - 0.015625f, this.lastRenderWidth + 0.015625f);
    }

    @Override
    protected void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = iterator.next();
                if (!wasConnected || fluidPacket.getTargetDirection() == direction && fluidPacket.getFromDirection() != direction && fluidPacket.getProgress() < 1024) {
                    this.routePacket(state, fluidPacket);
                    continue;
                }
                if ((fluidPacket.getFromDirection() != direction || fluidPacket.getProgress() >= 1024) && (fluidPacket.getTargetDirection() != direction || fluidPacket.getProgress() < 1024)) continue;
                iterator.remove();
            }
            this.addQueuedPackets((Level)level, false);
        }
        this.setChanged();
        level.sendBlockUpdated(pos, state, state, 2);
    }

    @Override
    public int getComparatorOutput() {
        if (this.contents.isEmpty()) {
            return 0;
        }
        return Math.max(1, Math.round(15.0f * (float)this.totalAmount() / 1000.0f));
    }

    @Override
    public short getTargetSpeed() {
        FluidState fluidState = this.fluid.defaultFluidState();
        if (fluidState.is(ClassicPipes.THIN_FLUIDS)) {
            return 256;
        }
        if (fluidState.is(ClassicPipes.THICK_FLUIDS) && this.level != null && !this.level.dimensionType().ultraWarm()) {
            return 64;
        }
        return 128;
    }

    @Override
    public short getAcceleration() {
        return 1;
    }

    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.contents.clear();
        this.tickAdded.clear();
        super.loadAdditional(valueInput, registries);
        ListTag fluidPacketList = valueInput.getList("fluid_packets", 10);
        fluidPacketList.forEach(tag -> MiscUtil.loadFromTag(tag, FluidInPipe.CODEC, registries, this.contents::add));
        MiscUtil.loadFromTag(valueInput.get("fluid"), BuiltInRegistries.FLUID.byNameCodec(), registries, this::setFluid);
    }

    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        ListTag fluidPacketList = new ListTag();
        for (FluidInPipe fluidPacket : this.contents) {
            if (fluidPacket.getAmount() <= 0) continue;
            MiscUtil.saveToTag((Tag)new CompoundTag(), fluidPacket, FluidInPipe.CODEC, registries, arg_0 -> fluidPacketList.add(arg_0));
        }
        valueOutput.put("fluid_packets", (Tag)fluidPacketList);
        valueOutput.put("fluid", (Tag)BuiltInRegistries.FLUID.byNameCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.fluid).getOrThrow());
    }

    public void addQueuedPackets(Level level, boolean waitForNextTick) {
        for (FluidInPipe fluidPacket : this.queued) {
            this.contents.add(fluidPacket);
            if (!waitForNextTick) continue;
            this.tickAdded.put(fluidPacket, level.getGameTime());
        }
        this.setChanged();
        this.queued.clear();
    }

    public boolean emptyOrMatches(Fluid fluid) {
        return this.contents.isEmpty() || this.fluid == fluid;
    }

    public int totalAmount() {
        int total = 0;
        for (FluidInPipe fluidPacket : this.contents) {
            total += fluidPacket.getAmount();
        }
        return total;
    }

    public int remainingCapacity() {
        return 1000 - this.totalAmount();
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public void insertFluidPacket(Level level, FluidInPipe fluidPacket) {
        this.queued.add(fluidPacket);
        this.routePacket(fluidPacket);
        this.addQueuedPackets(level, true);
    }

    protected List<Direction> getValidDirections(BlockState state, FluidInPipe fluidPacket) {
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return validDirections;
    }

    public void routePacket(BlockState state, FluidInPipe fluidPacket) {
        List<Direction> validDirections = this.getValidDirections(state, fluidPacket);
        int numDirections = validDirections.size();
        if (numDirections == 0) {
            fluidPacket.setTargetDirection(fluidPacket.getFromDirection());
        } else if (numDirections == 1) {
            fluidPacket.setTargetDirection(validDirections.getFirst());
        } else if (fluidPacket.getAmount() > 20) {
            int splitAmount = fluidPacket.getAmount() / numDirections;
            int leftoverAmount = fluidPacket.getAmount() % numDirections;
            Collections.shuffle(validDirections);
            for (int i = 0; i < numDirections; ++i) {
                if (i == 0) {
                    fluidPacket.setAmount(splitAmount + leftoverAmount);
                    fluidPacket.setTargetDirection(validDirections.get(i));
                    continue;
                }
                FluidInPipe newPacket = fluidPacket.copyWithAmount(splitAmount);
                newPacket.setTargetDirection(validDirections.get(i));
                this.queued.add(newPacket);
            }
        } else if (this.getLevel() != null) {
            fluidPacket.setTargetDirection(validDirections.get(this.getLevel().getRandom().nextInt(validDirections.size())));
        }
    }

    public void routePacket(FluidInPipe fluidPacket) {
        this.routePacket(this.getBlockState(), fluidPacket);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public List<FluidInPipe> getContents() {
        return this.contents;
    }
}

