/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.colorfulallays.mixin;

import com.breakinblocks.colorfulallays.Config;
import com.breakinblocks.colorfulallays.component.ColorableAllay;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Allay.class})
public class AllayMixin
implements ColorableAllay {
    @Unique
    private static final DyeColor colorfulallays$DEFAULT_DYE_COLOR = DyeColor.LIGHT_BLUE;
    @Unique
    private static final EntityDataAccessor<Integer> colorfulallays$DYE_COLOR_ID = SynchedEntityData.defineId(Allay.class, (EntityDataSerializer)EntityDataSerializers.INT);

    @Shadow
    private void resetDuplicationCooldown() {
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void colorfulallays$defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(colorfulallays$DYE_COLOR_ID, (Object)colorfulallays$DEFAULT_DYE_COLOR.getId());
    }

    @Override
    @Unique
    public DyeColor colorfulallays$getDyeColor() {
        int dyeId = (Integer)((Allay)this).getEntityData().get(colorfulallays$DYE_COLOR_ID);
        return DyeColor.byId((int)dyeId);
    }

    @Override
    @Unique
    public void colorfulallays$setDyeColor(DyeColor dyeColor) {
        ((Allay)this).getEntityData().set(colorfulallays$DYE_COLOR_ID, (Object)dyeColor.getId());
    }

    @Override
    @Unique
    public boolean colorfulallays$hasCustomColor() {
        return this.colorfulallays$getDyeColor() != colorfulallays$DEFAULT_DYE_COLOR;
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")})
    private void colorfulallays$handleAnyInteraction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Allay allay = (Allay)this;
        if (!allay.level().isClientSide && Config.enableInteractionPersistence && !allay.isPersistenceRequired()) {
            allay.setPersistenceRequired();
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void colorfulallays$handleDyeInteraction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Level serverLevel;
        Item item;
        Allay allay = (Allay)this;
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && (item = itemStack.getItem()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            if (!allay.level().isClientSide) {
                Level level;
                ((ColorableAllay)allay).colorfulallays$setDyeColor(dyeItem.getDyeColor());
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                if ((level = allay.level()) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 10; ++i) {
                        double offsetX = allay.getRandom().nextGaussian() * 0.5;
                        double offsetY = allay.getRandom().nextGaussian() * 0.5;
                        double offsetZ = allay.getRandom().nextGaussian() * 0.5;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, allay.getX() + offsetX, allay.getY() + 0.5 + offsetY, allay.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                allay.playSound(SoundEvents.DYE_USE, 1.0f, 1.0f);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        if (player.isShiftKeyDown() && itemStack.is(Items.WATER_BUCKET)) {
            if (!allay.level().isClientSide && ((ColorableAllay)allay).colorfulallays$hasCustomColor()) {
                ((ColorableAllay)allay).colorfulallays$setDyeColor(colorfulallays$DEFAULT_DYE_COLOR);
                serverLevel = allay.level();
                if (serverLevel instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)serverLevel;
                    for (int i = 0; i < 15; ++i) {
                        double offsetX = allay.getRandom().nextGaussian() * 0.5;
                        double offsetY = allay.getRandom().nextGaussian() * 0.5;
                        double offsetZ = allay.getRandom().nextGaussian() * 0.5;
                        serverLevel2.sendParticles((ParticleOptions)ParticleTypes.SPLASH, allay.getX() + offsetX, allay.getY() + 0.5 + offsetY, allay.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                allay.playSound(SoundEvents.GENERIC_SPLASH, 1.0f, 1.0f);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void colorfulallays$saveColorData(CompoundTag compound, CallbackInfo ci) {
        DyeColor dyeColor = this.colorfulallays$getDyeColor();
        if (dyeColor != colorfulallays$DEFAULT_DYE_COLOR) {
            compound.putInt("colorfulallays:dyeColor", dyeColor.getId());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void colorfulallays$loadColorData(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("colorfulallays:dyeColor")) {
            int dyeId = compound.getInt("colorfulallays:dyeColor");
            this.colorfulallays$setDyeColor(DyeColor.byId((int)dyeId));
        }
    }

    @Inject(method={"duplicateAllay"}, at={@At(value="HEAD")}, cancellable=true)
    private void colorfulallays$overrideDuplicateAllay(CallbackInfo ci) {
        Allay thisAllay = (Allay)this;
        Allay duplicatedAllay = (Allay)EntityType.ALLAY.create(thisAllay.level());
        if (duplicatedAllay != null) {
            duplicatedAllay.moveTo(thisAllay.position());
            duplicatedAllay.setPersistenceRequired();
            ((AllayMixin)duplicatedAllay).resetDuplicationCooldown();
            this.resetDuplicationCooldown();
            DyeColor parentColor = this.colorfulallays$getDyeColor();
            ((ColorableAllay)duplicatedAllay).colorfulallays$setDyeColor(parentColor);
            thisAllay.level().addFreshEntity((Entity)duplicatedAllay);
        }
        ci.cancel();
    }
}

