/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.upgrade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstanceKey;
import dev.compactmods.machines.data.AttachmentBasedDataFile;
import dev.compactmods.machines.data.AttachmentDataFileFactoryInput;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;

public class RoomUpgradeDataAttachments
extends AttachmentBasedDataFile<RoomUpgradeDataAttachments, RoomUpgradeMetadata> {
    private final RoomUpgradeInstanceKey upgradeId;

    public RoomUpgradeDataAttachments(MinecraftServer server, RoomUpgradeInstanceKey upgradeId) {
        super(server, RoomUpgradeMetadata.CODEC, RoomUpgradeDataAttachments::new);
        this.upgradeId = upgradeId;
    }

    public RoomUpgradeDataAttachments(AttachmentDataFileFactoryInput<RoomUpgradeMetadata> input) {
        super(input.server(), RoomUpgradeMetadata.CODEC, RoomUpgradeDataAttachments::new);
        this.upgradeId = input.additionalData().upgradeId();
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return ((Path)CMRoomDataLocations.ROOM_DATA_ATTACHMENTS.apply(server)).resolve("upgrade_data").resolve(this.upgradeId.roomCode());
    }

    @Override
    public Codec<RoomUpgradeDataAttachments> codec() {
        return this.codec;
    }

    @Override
    protected RoomUpgradeMetadata dataSupplier(RoomUpgradeDataAttachments instance) {
        return new RoomUpgradeMetadata(instance.upgradeId);
    }

    public record RoomUpgradeMetadata(RoomUpgradeInstanceKey upgradeId) {
        public static MapCodec<RoomUpgradeMetadata> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RoomUpgradeInstanceKey.CODEC.fieldOf("instance_id").forGetter(RoomUpgradeMetadata::upgradeId)).apply((Applicative)i, RoomUpgradeMetadata::new));
    }
}

