/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.tag.BalmItemTags;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenOperation;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableContainer;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BalmBlockEntity
implements KitchenItemProcessor,
BalmMenuProvider<BlockPos>,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider,
CustomRenderBoundingBox,
TransferableBlockEntity<TransferableContainer> {
    private static final int COOK_TIME = 200;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (slot < 3) {
                return !OvenBlockEntity.this.getSmeltingResult(itemStack).isEmpty();
            }
            if (slot == 3) {
                return OvenBlockEntity.isItemFuel(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                OvenBlockEntity.this.slotCookTime[slot - 7] = 0;
            }
            OvenBlockEntity.this.isDirty = true;
            OvenBlockEntity.this.setChanged();
        }
    };
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int id) {
            if (id == 0) {
                return OvenBlockEntity.this.furnaceBurnTime;
            }
            if (id == 1) {
                return OvenBlockEntity.this.currentItemBurnTime;
            }
            if (id >= 2 && id <= 11) {
                return OvenBlockEntity.this.slotCookTime[id - 2];
            }
            return 0;
        }

        public void set(int id, int value) {
            if (id == 0) {
                OvenBlockEntity.this.furnaceBurnTime = value;
            } else if (id == 1) {
                OvenBlockEntity.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                OvenBlockEntity.this.slotCookTime[id - 2] = value;
            }
        }

        public int getCount() {
            return 11;
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.setChanged();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.setChanged();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final SubContainer inputContainer = new SubContainer((Container)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((Container)this.container, 3, 4);
    private final SubContainer outputContainer = new SubContainer((Container)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((Container)this.container, 7, 16);
    private final SubContainer toolsContainer = new SubContainer((Container)this.container, 16, 20);
    private final KitchenItemProvider itemProvider = new ContainerKitchenItemProvider((Container)new CombinedContainer(new Container[]{this.toolsContainer, this.outputContainer}));
    private final DoorAnimator doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
    private Component customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private Direction facing;

    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.oven.get(), pos, state);
        this.doorAnimator.setSoundEventOpen((SoundEvent)ModSounds.ovenOpen.get());
        this.doorAnimator.setSoundEventClose((SoundEvent)ModSounds.ovenClose.get());
    }

    public boolean triggerEvent(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.triggerEvent(id, type);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, OvenBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OvenBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isFirstTick && state.hasProperty((Property)OvenBlock.FACING)) {
            this.facing = (Direction)state.getValue((Property)OvenBlock.FACING);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.isClientSide) {
            ItemStack itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.fuelContainer.getContainerSize(); ++i) {
                    ItemStack fuelItem = this.fuelContainer.getItem(i);
                    if (fuelItem.isEmpty()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)OvenBlockEntity.getBurnTime(fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.shrink(1);
                    if (fuelItem.isEmpty()) {
                        this.fuelContainer.setItem(i, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.processingContainer.getContainerSize(); ++i) {
                itemStack = this.processingContainer.getItem(i);
                if (!itemStack.isEmpty()) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).isEmpty()) continue;
                        ItemStack resultStack = smeltingResult.copy();
                        this.processingContainer.setItem(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.worldPosition, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                ItemStack transferStack = this.processingContainer.getItem(firstTransferSlot);
                transferStack = ContainerUtils.insertItemStacked((Container)this.outputContainer, (ItemStack)transferStack, (boolean)false);
                this.processingContainer.setItem(firstTransferSlot, transferStack);
                if (transferStack.isEmpty()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.inputContainer.getContainerSize(); ++j) {
                    itemStack = this.inputContainer.getItem(j);
                    if (itemStack.isEmpty()) continue;
                    this.processingContainer.setItem(firstEmptySlot, itemStack.split(1));
                    if (itemStack.getCount() > 0) break;
                    this.inputContainer.setItem(j, ItemStack.EMPTY);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.setChanged();
        }
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(itemStack);
        ItemStack ovenRecipeResult = this.getSmeltingResult(ModRecipes.ovenRecipeType, recipeInput);
        if (!ovenRecipeResult.isEmpty()) {
            return ovenRecipeResult;
        }
        return this.getSmeltingResult(RecipeType.SMELTING, recipeInput);
    }

    public <T extends RecipeInput> ItemStack getSmeltingResult(RecipeType<? extends Recipe<T>> recipeType, T container) {
        ItemStack result;
        RecipeHolder recipe = this.level.getRecipeManager().getRecipeFor(recipeType, container, this.level).orElse(null);
        if (recipe != null && !(result = recipe.value().getResultItem((HolderLookup.Provider)this.level.registryAccess())).isEmpty() && result.has(DataComponents.FOOD)) {
            return result;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.is(BalmItemTags.COOKING_OIL);
        }
        return OvenBlockEntity.getBurnTime(itemStack) > 0;
    }

    protected static int getBurnTime(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return 0;
        }
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.is(BalmItemTags.COOKING_OIL)) {
            return 800;
        }
        return Balm.getHooks().getBurnTime(itemStack);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.getContainerSize(); ++i) {
            ItemStack cookingStack = this.processingContainer.getItem(i);
            if (cookingStack.isEmpty() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        Component customNameComponent = (Component)input.get(DataComponents.CUSTOM_NAME);
        if (customNameComponent != null) {
            this.customName = customNameComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.container.deserialize(tagCompound.getCompound("ItemHandler"), provider);
        this.furnaceBurnTime = tagCompound.getShort("BurnTime");
        this.currentItemBurnTime = tagCompound.getShort("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.getIntArray("CookTimes");
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = tagCompound.getBoolean("HasPowerUpgrade");
        this.energyStorage.setEnergy(tagCompound.getInt("EnergyStored"));
        if (tagCompound.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tagCompound.getString("CustomName"), (HolderLookup.Provider)provider);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("ItemHandler", (Tag)this.container.serialize(provider));
        tag.putShort("BurnTime", (short)this.furnaceBurnTime);
        tag.putShort("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tag.putIntArray("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tag.putBoolean("HasPowerUpgrade", this.hasPowerUpgrade);
        tag.putInt("EnergyStored", this.energyStorage.getEnergy());
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        if (tag.contains("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.getBoolean("IsForcedOpen"));
        }
        if (tag.contains("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.getByte("NumPlayersUsing"));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        tag.putBoolean("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.putByte("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        this.setChanged();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        if (this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0) {
            return 1.0f;
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    @Override
    public boolean canProcess(RecipeType<?> recipeType) {
        return recipeType == RecipeType.SMELTING;
    }

    @Override
    public KitchenOperation processRecipe(Recipe<?> recipe, List<IngredientToken> ingredientTokens) {
        for (IngredientToken ingredientToken : ingredientTokens) {
            ItemStack itemStack = ingredientToken.consume();
            ItemStack restStack = ContainerUtils.insertItemStacked((Container)this.inputContainer, (ItemStack)itemStack, (boolean)false);
            if (restStack.isEmpty()) continue;
            ingredientToken.restore(restStack);
        }
        return OvenOperation.INSTANCE;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public ItemStack getToolItem(int i) {
        return this.toolsContainer.getItem(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.toolsContainer.setItem(i, itemStack);
    }

    public Container getContainer(Direction side) {
        if (CookingForBlockheadsConfig.getActive().disallowOvenAutomation) {
            return null;
        }
        if (side == null) {
            return this.getInternalContainer();
        }
        return switch (side) {
            case Direction.UP -> this.inputContainer;
            case Direction.DOWN -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider), new BalmProvider(KitchenItemProcessor.class, (Object)this)});
    }

    public Container getInputContainer() {
        return this.inputContainer;
    }

    public Container getFuelContainer() {
        return this.fuelContainer;
    }

    public Direction getFacing() {
        return this.facing == null ? Direction.NORTH : this.facing;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new OvenMenu(i, playerInventory, this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1).getCenter(), this.worldPosition.offset(2, 1, 2).getCenter());
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.oven");
    }

    public Container getInternalContainer() {
        return this.container;
    }

    public Container getContainer() {
        if (CookingForBlockheadsConfig.getActive().disallowOvenAutomation) {
            return null;
        }
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    @Override
    public TransferableContainer snapshotDataForTransfer() {
        return TransferableContainer.copyAndClear((Container)this.container);
    }

    @Override
    public void restoreFromTransferSnapshot(TransferableContainer data) {
        data.applyTo((Container)this.container);
    }

    private static class OvenOperation
    implements KitchenOperation {
        public static final KitchenOperation INSTANCE = new OvenOperation();

        private OvenOperation() {
        }

        @Override
        public Optional<Component> getFeedback() {
            return Optional.of(Component.translatable((String)"gui.cookingforblockheads.moved_to_oven").withStyle(ChatFormatting.YELLOW));
        }
    }
}

