/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Screens.CUOption;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class LoadedChunkData {
    Map<String, Set<ChunkPos>> chunksByTicketName = new HashMap<String, Set<ChunkPos>>();
    Map<String, Set<ChunkPos>> chunksByLocationType = new HashMap<String, Set<ChunkPos>>();
    Map<ChunkPos, Set<String>> ticketsByChunk = new HashMap<ChunkPos, Set<String>>();
    Map<ChunkPos, String> locationTypeByChunk = new HashMap<ChunkPos, String>();
    Map<String, LocationTickets> ticketsByLocation = new HashMap<String, LocationTickets>();
    int total = 0;

    public Map<String, Set<ChunkPos>> getChunksByTicketName() {
        return this.chunksByTicketName;
    }

    public Map<String, Set<ChunkPos>> getChunksByLocationType() {
        return this.chunksByLocationType;
    }

    public LoadedChunkData(Map<String, Set<ChunkPos>> chunksByTicketName, Map<String, Set<ChunkPos>> chunksByLocationType) {
        this.chunksByTicketName = chunksByTicketName;
        this.chunksByLocationType = chunksByLocationType;
    }

    public LoadedChunkData(List<ServerLevel> worlds) {
        CrashUtils.runNextTick(world -> this.init(worlds));
    }

    public void init(List<ServerLevel> worlds) {
        for (Level level : worlds) {
            ChunkMap chunkManager = ((ServerChunkCache)level.getChunkSource()).chunkMap;
            DistanceManager ticketManager = chunkManager.getDistanceManager();
            this.total += chunkManager.size();
            Iterable chunkHolders = chunkManager.getChunks();
            chunkHolders.forEach(chunkHolder -> {
                ChunkAccess chunk = chunkHolder.getLatestChunk();
                LocationTickets ticketCounter = null;
                if (chunk == null) {
                    this.chunksByLocationType.merge("PRIMED", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.getPos())), (list, newer) -> {
                        list.add(chunkHolder.getPos());
                        return list;
                    });
                    this.ticketsByLocation.merge("PRIMED", new LocationTickets(), (x, y) -> {
                        ++x.count;
                        return x;
                    });
                    ticketCounter = this.ticketsByLocation.get("PRIMED");
                } else if (chunk instanceof LevelChunk) {
                    LevelChunk actualChunk = (LevelChunk)chunk;
                    this.chunksByLocationType.merge(actualChunk.getFullStatus().toString(), new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.getPos())), (list, newer) -> {
                        list.add(chunkHolder.getPos());
                        return list;
                    });
                    this.ticketsByLocation.merge(actualChunk.getFullStatus().toString(), new LocationTickets(), (x, y) -> {
                        ++x.count;
                        return x;
                    });
                    ticketCounter = this.ticketsByLocation.get(actualChunk.getFullStatus().toString());
                } else if (chunk instanceof ProtoChunk) {
                    this.chunksByLocationType.merge(chunk.getPersistedStatus() == ChunkStatus.FULL ? "FULL" : "PARTIALLYGENERATED", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.getPos())), (list, newer) -> {
                        list.add(chunkHolder.getPos());
                        return list;
                    });
                    this.ticketsByLocation.merge(chunk.getPersistedStatus() == ChunkStatus.FULL ? "FULL" : "PARTIALLYGENERATED", new LocationTickets(), (x, y) -> {
                        ++x.count;
                        return x;
                    });
                    ticketCounter = this.ticketsByLocation.get(chunk.getPersistedStatus() == ChunkStatus.FULL ? "FULL" : "PARTIALLYGENERATED");
                }
                SortedArraySet tickets = ticketManager.getTickets(chunkHolder.getPos().toLong());
                if (tickets.isEmpty()) {
                    this.chunksByTicketName.merge("no_ticket", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.getPos())), (old, nothing) -> {
                        old.add(chunkHolder.getPos());
                        return old;
                    });
                } else {
                    for (Ticket ticket : tickets) {
                        this.chunksByTicketName.merge(ticket.getType().toString(), new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.getPos())), (old, nothing) -> {
                            old.add(chunkHolder.getPos());
                            return old;
                        });
                        if (ticketCounter == null) continue;
                        ticketCounter.tickets.merge(ticket.getType().toString(), 1, Integer::sum);
                    }
                }
            });
        }
    }

    public void reply(CommandSourceStack source) {
        this.ticketsByLocation.forEach((name, locationticket) -> {
            source.sendSuccess(() -> CommandUtils.CreateTextComponent(name + ": " + locationticket.count), true);
            locationticket.tickets.forEach((ticket, count) -> source.sendSuccess(() -> CommandUtils.CreateTextComponent("    " + ticket + ": " + count), true));
        });
        source.sendSuccess(() -> CommandUtils.CreateTextComponent("Non-Ticking chunks have little to no performance impact. See the GUI and minecraft wiki for what each type represents."), false);
    }

    public void replyWithLocation(CommandSourceStack source, String word) throws CommandSyntaxException {
        source.sendSuccess(() -> CommandUtils.CreateTextComponent("Chunks with LocationType " + word), true);
        Set<ChunkPos> chunkPos = this.chunksByLocationType.get(word);
        if (chunkPos != null) {
            this.sendChunkPositions(source, chunkPos);
        }
    }

    private void sendChunkPositions(CommandSourceStack source, Set<ChunkPos> chunks) throws CommandSyntaxException {
        for (ChunkPos chunkPos : chunks) {
            BlockPos pos = chunkPos.getWorldPosition();
            CommandUtils.sendCommandMessage(source, CommandUtils.CreateTextComponent(chunkPos.toString()), "/cu tp " + (source.getEntity() instanceof Player ? source.getPlayerOrException().getName().getString() : "Console") + " " + pos.getX() + " " + pos.getY() + " " + pos.getZ(), true);
        }
    }

    public void replyWithTicket(CommandSourceStack source, String word) throws CommandSyntaxException {
        Set<ChunkPos> chunks = this.chunksByTicketName.get(word);
        if (chunks == null) {
            return;
        }
        source.sendSuccess(() -> CommandUtils.CreateTextComponent("Chunks with " + word + " Ticket"), true);
        this.sendChunkPositions(source, chunks);
    }

    public void createReverseMapping() {
        this.chunksByTicketName.forEach((x, y) -> y.forEach(t -> this.ticketsByChunk.merge((ChunkPos)t, (Set<String>)new HashSet<String>(Collections.singleton(x)), (old, n) -> {
            old.add(x);
            return old;
        })));
        this.chunksByLocationType.forEach((x, y) -> y.forEach(t -> this.locationTypeByChunk.put((ChunkPos)t, (String)x)));
    }

    public String getTickets(ChunkPos pos) {
        Set<String> strings = this.ticketsByChunk.get(pos);
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        if (strings.size() > 1) {
            strings.remove("unknown");
        }
        StringBuilder toReturn = new StringBuilder();
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            toReturn.append(it.next());
            if (!it.hasNext()) continue;
            toReturn.append(", ");
        }
        return toReturn.toString();
    }

    public String getLocationType(ChunkPos pos) {
        return this.locationTypeByChunk.get(pos);
    }

    public List<CUOption> getTicketsAsDropdownOptions(String filter) {
        return this.getCuDropDownOptions(filter, this.chunksByTicketName);
    }

    public List<CUOption> getStatesAsDropdownOptions(String filter) {
        return this.getCuDropDownOptions(filter, this.chunksByLocationType);
    }

    private List<CUOption> getCuDropDownOptions(String filter, Map<String, Set<ChunkPos>> chunkMap) {
        ArrayList<CUOption> list = new ArrayList<CUOption>();
        if (filter.isEmpty()) {
            chunkMap.forEach((string, set) -> list.add(new CUOption((String)string, set.size())));
        } else if (!chunkMap.get(filter).isEmpty()) {
            chunkMap.get(filter).forEach(chunkPos -> list.add(new CUOption((ChunkPos)chunkPos)));
        }
        return list;
    }

    private static class LocationTickets {
        int count;
        Map<String, Integer> tickets = new HashMap<String, Integer>();

        private LocationTickets() {
        }
    }
}

