/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.client.events;

import com.adonis.createshimmer.common.registry.CSEffects;
import com.adonis.createshimmer.config.CSConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CSClientEvents {
    @SubscribeEvent
    public void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft minecraft = Minecraft.getInstance();
        LivingEntity viewEntity = null;
        Entity entity = minecraft.getCameraEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            viewEntity = living = (LivingEntity)entity;
        } else if (minecraft.player != null) {
            viewEntity = minecraft.player;
        }
        if (viewEntity != null && viewEntity.hasEffect(CSEffects.SHIMMER_EFFECT)) {
            float purpleStrength = 0.9f;
            event.setRed(event.getRed() * (1.0f - purpleStrength) + purpleStrength * 0.29f);
            event.setGreen(event.getGreen() * (1.0f - purpleStrength) + purpleStrength * 0.08f);
            event.setBlue(event.getBlue() * (1.0f - purpleStrength) + purpleStrength * 0.55f);
        }
    }

    @SubscribeEvent
    public void onRenderFog(ViewportEvent.RenderFog event) {
        Minecraft minecraft = Minecraft.getInstance();
        LivingEntity viewEntity = null;
        Entity entity = minecraft.getCameraEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            viewEntity = living = (LivingEntity)entity;
        } else if (minecraft.player != null) {
            viewEntity = minecraft.player;
        }
        if (viewEntity != null && viewEntity.hasEffect(CSEffects.SHIMMER_EFFECT) && event.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            float originalStart = event.getNearPlaneDistance();
            float originalEnd = event.getFarPlaneDistance();
            event.setNearPlaneDistance(originalStart * 0.1f);
            event.setFarPlaneDistance(originalEnd * 0.1f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onComputeFovModifier(ComputeFovModifierEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.player.hasEffect(CSEffects.SHIMMER_EFFECT) && ((Boolean)CSConfig.client().shimmerFovEnabled.get()).booleanValue()) {
            float fovModifier = ((Double)CSConfig.client().shimmerFovMultiplier.get()).floatValue();
            event.setNewFovModifier(event.getFovModifier() * fovModifier);
        }
    }

    @SubscribeEvent
    public void onRenderGuiLayer(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CAMERA_OVERLAYS)) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player != null && minecraft.player.hasEffect(CSEffects.SHIMMER_EFFECT) && !minecraft.player.isSpectator() && minecraft.options.getCameraType().isFirstPerson()) {
                this.renderShimmerScreenOverlay(event.getGuiGraphics());
            }
        }
    }

    private void renderShimmerScreenOverlay(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.getInstance();
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float red = 0.2f;
        float green = 0.05f;
        float blue = 0.4f;
        float alpha = 0.45f;
        long time = System.currentTimeMillis();
        float pulse = (float)(Math.sin((double)time * 0.003) * 0.1 + 1.0);
        bufferbuilder.addVertex(matrix, 0.0f, (float)screenHeight, 0.0f).setColor(red, green, blue, alpha *= pulse);
        bufferbuilder.addVertex(matrix, (float)screenWidth, (float)screenHeight, 0.0f).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix, (float)screenWidth, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }
}

