/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.common.kinetics.fan.transmutation;

import com.adonis.createshimmer.common.registry.CSEffects;
import com.adonis.createshimmer.common.registry.CSFluids;
import com.adonis.createshimmer.common.registry.CSRecipes;
import com.adonis.createshimmer.config.CSConfig;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TransmutationFanProcessingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        boolean configEnabled = (Boolean)CSConfig.recipes().enableBulkTransmutation.get();
        if (!configEnabled) {
            return false;
        }
        FluidState fluidState = level.getFluidState(pos);
        TagKey<Fluid> catalystTag = CSFluids.MOD_TAGS.fanTransmutationCatalysts;
        Registry registry = level.registryAccess().registryOrThrow(BuiltInRegistries.FLUID.key());
        if (!registry.getTag(catalystTag).isPresent()) {
            return false;
        }
        return fluidState.is(catalystTag);
    }

    public int getPriority() {
        return 370;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CSRecipes.TRANSMUTATION.getType(), (RecipeInput)input, level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CSRecipes.TRANSMUTATION.getType(), (RecipeInput)input, level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipe.value(), (boolean)false)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(6) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.5, 0.0);
        }
        if (level.random.nextInt(12) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.CRIT, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), (double)((level.random.nextFloat() - 0.5f) * 0.2f), (double)0.1f, (double)((level.random.nextFloat() - 0.5f) * 0.2f));
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)10112511, (int)16766720, (float)random.nextFloat()));
        particleAccess.setAlpha(1.0f);
    }

    public void affectEntity(Entity entity, Level level) {
        LivingEntity livingEntity;
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAffectedByPotions() && entity.tickCount % 20 == 0) {
            livingEntity.addEffect(new MobEffectInstance(CSEffects.SHIMMER_EFFECT, 60, 0));
        }
    }
}

