/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.util;

import com.adonis.createshimmer.config.CSConfig;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ScepterRepairHelper {
    private static final Set<String> REPAIRABLE_SCEPTERS = Set.of("twilightforest:lifedrain_scepter", "twilightforest:zombie_scepter", "twilightforest:fortification_scepter", "twilightforest:twilight_scepter");

    public static boolean isRepairableScepter(ItemStack stack) {
        if (stack.isEmpty() || !stack.isDamageableItem()) {
            return false;
        }
        if (!((Boolean)CSConfig.repair().enableScepterRepair.get()).booleanValue()) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        boolean isRepairable = REPAIRABLE_SCEPTERS.contains(itemId.toString());
        return isRepairable;
    }

    public static boolean needsRepair(ItemStack stack) {
        boolean needs = ScepterRepairHelper.isRepairableScepter(stack) && stack.getDamageValue() > 0;
        return needs;
    }

    public static int getRepairCost(ItemStack stack) {
        if (!ScepterRepairHelper.isRepairableScepter(stack)) {
            return 0;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String scepterId = itemId.toString();
        int cost = scepterId.equals("twilightforest:twilight_scepter") ? (Integer)CSConfig.repair().twilightScepterRepairCost.get() : (scepterId.equals("twilightforest:lifedrain_scepter") ? (Integer)CSConfig.repair().lifedrainScepterRepairCost.get() : (scepterId.equals("twilightforest:zombie_scepter") ? (Integer)CSConfig.repair().zombieScepterRepairCost.get() : (scepterId.equals("twilightforest:fortification_scepter") ? (Integer)CSConfig.repair().fortificationScepterRepairCost.get() : 0)));
        return cost;
    }

    public static int getRepairAmount() {
        int amount = (Integer)CSConfig.repair().scepterRepairAmount.get();
        return amount;
    }

    public static ItemStack repairScepter(ItemStack originalScepter) {
        if (!ScepterRepairHelper.needsRepair(originalScepter)) {
            return originalScepter.copy();
        }
        ItemStack repairedScepter = originalScepter.copy();
        int currentDamage = repairedScepter.getDamageValue();
        int repairAmount = ScepterRepairHelper.getRepairAmount();
        int newDamage = Math.max(0, currentDamage - repairAmount);
        repairedScepter.setDamageValue(newDamage);
        return repairedScepter;
    }

    public static boolean isDebugMode() {
        try {
            return (Boolean)CSConfig.repair().debugMode.get();
        }
        catch (Exception e) {
            return false;
        }
    }
}

