/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.slab;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.copycat.ICopycatWithWrappedBlock;
import com.hlysine.create_connected.content.copycat.MigratingWaterloggedCopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopycatSlabBlock
extends MigratingWaterloggedCopycatBlock
implements ICopycatWithWrappedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<SlabType> SLAB_TYPE = BlockStateProperties.SLAB_TYPE;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatSlabBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
    }

    @Override
    public Block getWrappedBlock() {
        return Blocks.SMOOTH_STONE_SLAB;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown() && player.mayBuild()) {
            ItemStack heldItem = player.getItemInHand(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)heldItem.getItem(), player, hand, hitResult);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        if (fromPos == null || toPos == null) {
            return true;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        BlockState toState = reader.getBlockState(toPos);
        if (toState.is((Block)this)) {
            if (toState.getValue(AXIS) != axis) {
                return true;
            }
            return CopycatSlabBlock.getFaceShape(state, face) != CopycatSlabBlock.getFaceShape(toState, face);
        }
        if (face.getAxis() != axis) {
            return true;
        }
        return CopycatSlabBlock.getFaceShape(state, face) != FaceShape.FULL;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        BlockState toState = reader.getBlockState(toPos);
        BlockPos diff = toPos.subtract((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.ZERO)) {
            return true;
        }
        Direction face = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (face == null) {
            boolean correctAxis = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (diff.getX() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (diff.getY() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> diff.getZ() == 0;
            };
            return correctAxis && diff.distManhattan(Vec3i.ZERO) <= 2;
        }
        if (face.getAxis() == axis) {
            return false;
        }
        if (toState.is((Block)this)) {
            return FaceShape.canConnect(CopycatSlabBlock.getFaceShape(state, face), CopycatSlabBlock.getFaceShape(toState, face.getOpposite()));
        }
        return true;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return CopycatSlabBlock.getFaceShape(state, face).hasContact();
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !CopycatSlabBlock.getFaceShape(state, face).hasContact();
    }

    @Override
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState stateForPlacement = super.getStateForPlacement(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(blockPos);
        if (this.isSelfState(state)) {
            return (BlockState)((BlockState)state.setValue(SLAB_TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        Direction.Axis axis = context.getNearestLookingDirection().getAxis();
        boolean flag = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (context.getClickLocation().x - (double)blockPos.getX() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (context.getClickLocation().y - (double)blockPos.getY() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> context.getClickLocation().z - (double)blockPos.getZ() > 0.5;
        };
        Direction clickedFace = context.getClickedFace();
        return (BlockState)((BlockState)stateForPlacement.setValue(AXIS, (Comparable)axis)).setValue(SLAB_TYPE, (Comparable)(clickedFace == Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || clickedFace.getAxis() != axis && !flag ? SlabType.BOTTOM : SlabType.TOP));
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.getItemInHand();
        SlabType slabtype = (SlabType)pState.getValue(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.getValue(AXIS);
        if (slabtype != SlabType.DOUBLE && itemstack.is(this.asItem())) {
            boolean flag = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (pUseContext.getClickLocation().x - (double)pUseContext.getClickedPos().getX() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (pUseContext.getClickLocation().y - (double)pUseContext.getClickedPos().getY() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> pUseContext.getClickLocation().z - (double)pUseContext.getClickedPos().getZ() > 0.5;
            };
            Direction direction = pUseContext.getClickedFace();
            if (slabtype == SlabType.BOTTOM) {
                return direction == Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || flag;
            }
            return direction == Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE) || !flag;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{AXIS}).add(new Property[]{SLAB_TYPE}));
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        SlabType type = (SlabType)pState.getValue(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.getValue(AXIS);
        if (type == SlabType.DOUBLE) {
            return Shapes.block();
        }
        if (type == SlabType.BOTTOM) {
            return CCShapes.CASING_8PX.get(axis);
        }
        return CCShapes.CASING_8PX_TOP.get(axis);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if ((neighborState.getBlock() instanceof SlabBlock || neighborState.getBlock() instanceof CopycatSlabBlock) && CopycatSlabBlock.getMaterial(level, pos).skipRendering(CopycatSlabBlock.getMaterial(level, pos.relative(dir)), dir.getOpposite())) {
            return CopycatSlabBlock.getFaceShape(state, dir) == CopycatSlabBlock.getFaceShape(neighborState, dir.getOpposite());
        }
        return CopycatSlabBlock.getFaceShape(state, dir) == FaceShape.FULL && CopycatSlabBlock.getMaterial(level, pos).skipRendering(neighborState, dir.getOpposite());
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockState state = CopycatBlock.getMaterial((BlockGetter)reader, (BlockPos)targetPos);
        if (state.is(Blocks.AIR)) {
            return reader.getBlockState(targetPos);
        }
        return state;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return CopycatSlabBlock.setApparentDirection(state, rot.rotate(CopycatSlabBlock.getApparentDirection(state)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation(CopycatSlabBlock.getApparentDirection(state)));
    }

    public static FaceShape getFaceShape(BlockState state, Direction face) {
        SlabType slab = (SlabType)state.getValue(SLAB_TYPE);
        if (state.getValue(AXIS) != face.getAxis()) {
            return FaceShape.forSlabSide(slab);
        }
        return switch (slab) {
            default -> throw new MatchException(null, null);
            case SlabType.TOP -> FaceShape.fullOrNone(face.getAxisDirection() == Direction.AxisDirection.POSITIVE);
            case SlabType.BOTTOM -> FaceShape.fullOrNone(face.getAxisDirection() == Direction.AxisDirection.NEGATIVE);
            case SlabType.DOUBLE -> FaceShape.FULL;
        };
    }

    public static Direction getApparentDirection(BlockState state) {
        return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue(AXIS)), (Direction.AxisDirection)(state.getValue(SLAB_TYPE) == SlabType.BOTTOM ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    public static BlockState setApparentDirection(BlockState state, Direction direction) {
        SlabType type = (SlabType)state.getValue(SLAB_TYPE);
        if (type == SlabType.DOUBLE) {
            return (BlockState)state.setValue(AXIS, (Comparable)direction.getAxis());
        }
        if (CopycatSlabBlock.getApparentDirection(state).getAxisDirection() != direction.getAxisDirection()) {
            return (BlockState)((BlockState)state.setValue(AXIS, (Comparable)direction.getAxis())).setValue(SLAB_TYPE, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
        }
        return (BlockState)state.setValue(AXIS, (Comparable)direction.getAxis());
    }

    private static enum FaceShape {
        FULL,
        TOP,
        BOTTOM,
        NONE;


        public static FaceShape forSlabSide(SlabType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case SlabType.TOP -> TOP;
                case SlabType.BOTTOM -> BOTTOM;
                case SlabType.DOUBLE -> FULL;
            };
        }

        public static FaceShape fullOrNone(boolean value) {
            return value ? FULL : NONE;
        }

        public static boolean canConnect(FaceShape shape1, FaceShape shape2) {
            return shape1 == shape2 || shape1 == FULL && shape2 != NONE || shape2 == FULL && shape1 != NONE;
        }

        public boolean hasContact() {
            return this != NONE;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)((Direction.Axis)state.getValue(AXIS)), dir -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.setValue(AXIS, (Comparable)((Direction.Axis)state.getValue(AXIS)))).setValue(SLAB_TYPE, (Comparable)((SlabType)state.getValue(SLAB_TYPE))));
        }
    }
}

