/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlock;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidVesselItem
extends BlockItem {
    public FluidVesselItem(Block p_i48527_1_, Item.Properties p_i48527_2_) {
        super(p_i48527_1_, p_i48527_2_);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.place(ctx);
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos blockPos, Level level, Player player, ItemStack itemStack, BlockState blockState) {
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return false;
        }
        CustomData blockEntityData = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blockEntityData != null) {
            FluidStack fluid;
            CompoundTag nbt = blockEntityData.copyTag();
            nbt.remove("Luminosity");
            nbt.remove("Size");
            nbt.remove("Height");
            nbt.remove("Controller");
            nbt.remove("LastKnownPos");
            if (nbt.contains("TankContent") && !(fluid = FluidStack.parseOptional((HolderLookup.Provider)minecraftserver.registryAccess(), (CompoundTag)nbt.getCompound("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(FluidTankBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.put("TankContent", fluid.saveOptional((HolderLookup.Provider)minecraftserver.registryAccess()));
            }
            BlockEntity.addEntityType((CompoundTag)nbt, (BlockEntityType)((IBE)this.getBlock()).getBlockEntityType());
            itemStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
        return super.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        if (!face.getAxis().isHorizontal()) {
            return;
        }
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        BlockState placedOnState = world.getBlockState(placedOnPos = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (!FluidVesselBlock.isVessel(placedOnState)) {
            return;
        }
        if (SymmetryWandItem.presentInHotbar((Player)player)) {
            return;
        }
        boolean creative = this.getBlock().equals(CCBlocks.CREATIVE_FLUID_VESSEL.get());
        FluidVesselBlockEntity tankAt = (FluidVesselBlockEntity)ConnectivityHandler.partAt((BlockEntityType)(creative ? (BlockEntityType)CCBlockEntityTypes.CREATIVE_FLUID_VESSEL.get() : (BlockEntityType)CCBlockEntityTypes.FLUID_VESSEL.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        FluidVesselBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.getWidth();
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        Direction.Axis vesselAxis = placedOnState.getOptionalValue(FluidVesselBlock.AXIS).orElse(null);
        if (vesselAxis == null) {
            return;
        }
        if (face.getAxis() != vesselAxis) {
            return;
        }
        Direction vesselFacing = Direction.fromAxisAndDirection((Direction.Axis)vesselAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == vesselFacing.getOpposite() ? controllerBE.getBlockPos().relative(vesselFacing.getOpposite()) : controllerBE.getBlockPos().relative(vesselFacing, controllerBE.getHeight());
        if (VecHelper.getCoordinate((Vec3i)startPos, (Direction.Axis)vesselAxis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)vesselAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vesselAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : startPos.offset(xOffset, zOffset, 0);
                blockState = world.getBlockState(offsetPos);
                if (FluidVesselBlock.isVessel(blockState)) continue;
                if (!blockState.canBeReplaced()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vesselAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : startPos.offset(xOffset, zOffset, 0);
                blockState = world.getBlockState(offsetPos);
                if (FluidVesselBlock.isVessel(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().putBoolean("SilenceVesselSound", true);
                super.place(context);
                player.getPersistentData().remove("SilenceVesselSound");
            }
        }
    }
}

