/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.util;

import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.item.WireSpool;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class Util {
    public static int max(int ... v) {
        int m = Integer.MIN_VALUE;
        for (int i : v) {
            if (i <= m) continue;
            m = i;
        }
        return m;
    }

    public static int min(int ... v) {
        int m = Integer.MAX_VALUE;
        for (int i : v) {
            if (i >= m) continue;
            m = i;
        }
        return m;
    }

    public static int minIndex(int ... v) {
        int m = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] >= v[m]) continue;
            m = i;
        }
        return m;
    }

    public static ItemStack findStack(Item item, Inventory inv) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.getItem() != item) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean canStack(ItemStack add, ItemStack to) {
        return add.getCount() + to.getCount() <= to.getMaxStackSize() && add.getItem() == to.getItem() || to.isEmpty();
    }

    public static int getMergeRest(ItemStack add, ItemStack to) {
        return Math.max(add.getCount() + to.getCount() - to.getMaxStackSize(), 0);
    }

    public static int getSkyLight(Level world, BlockPos pos) {
        return Math.max(world.getBrightness(LightLayer.SKY, pos) - world.getSkyDarken(), 0);
    }

    public static ItemStack mergeStack(ItemStack add, ItemStack to) {
        return new ItemStack((ItemLike)(to.isEmpty() ? add.getItem() : to.getItem()), to.getCount() + add.getCount());
    }

    public static String format(int n) {
        if (n >= 1000000000) {
            return (double)Math.round((double)n / 1.0E8) / 10.0 + "G";
        }
        if (n >= 1000000) {
            return (double)Math.round((double)n / 100000.0) / 10.0 + "M";
        }
        if (n >= 1000) {
            return (double)Math.round((double)n / 100.0) / 10.0 + "K";
        }
        return "" + n;
    }

    public static MutableComponent getTextComponent(IEnergyStorage ies, String nan, String unit) {
        if (ies == null) {
            return Component.literal((String)nan);
        }
        return Util.getTextComponent(ies.getEnergyStored(), unit).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.GRAY)).append((Component)Util.getTextComponent(ies.getMaxEnergyStored(), unit));
    }

    public static MutableComponent getTextComponent(IEnergyStorage ies) {
        return Util.getTextComponent(ies, "NaN", "\u26a1");
    }

    public static MutableComponent getTextComponent(int value, String unit) {
        return Component.literal((String)(Util.format(value) + unit));
    }

    public static Triple<BlockPos, Integer, WireType> getWireNodeOfSpools(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            CompoundTag tag;
            if (stack.isEmpty() || !WireSpool.hasPos(tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()))).copyTag())) continue;
            return Triple.of(WireSpool.getPos(tag), WireSpool.getNode(tag), WireType.of(stack.getItem()));
        }
        return null;
    }

    public static String formatTime(int ticks) {
        if (ticks > 1200) {
            return ticks / 1200 + "m";
        }
        if (ticks > 20) {
            return ticks / 20 + "s";
        }
        return ticks + "t";
    }

    public static class Triple<A, B, C> {
        public final A a;
        public final B b;
        public final C c;

        private Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public static <A, B, C> Triple<A, B, C> of(A a, B b, C c) {
            return new Triple<A, B, C>(a, b, c);
        }
    }
}

