/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.drill;

import com.simibubi.create.content.kinetics.drill.DrillBlockEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntity;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntityDelegate;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import joptsimple.internal.Strings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016J\u001e\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0014J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\u0017\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0096\u0001J\t\u0010$\u001a\u00020%H\u0096\u0001J\u0019\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001cH\u0096\u0001J\u0011\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020%H\u0096\u0001J\u0019\u0010+\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001cH\u0096\u0001\u00a8\u0006,"}, d2={"Lio/github/cotrin8672/cem/content/block/drill/EnchantableDrillBlockEntity;", "Lcom/simibubi/create/content/kinetics/drill/DrillBlockEntity;", "Lio/github/cotrin8672/cem/content/block/EnchantableBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "getBreakSpeed", "", "canBreak", "", "stateToBreak", "blockHardness", "onBlockBroken", "", "addToGoggleTooltip", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "read", "compound", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "clientPacket", "write", "getEnchantmentLevel", "", "enchantment", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantments", "Lnet/minecraft/world/item/enchantment/ItemEnchantments;", "readEnchantments", "tag", "provider", "setEnchantment", "enchantments", "writeEnchantments", "createenchantablemachinery"})
public final class EnchantableDrillBlockEntity
extends DrillBlockEntity
implements EnchantableBlockEntity {
    private final /* synthetic */ EnchantableBlockEntityDelegate $$delegate_0;

    public EnchantableDrillBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.$$delegate_0 = new EnchantableBlockEntityDelegate();
    }

    protected float getBreakSpeed() {
        BlockEntity blockEntity = (BlockEntity)this;
        ResourceKey resourceKey = Registries.ENCHANTMENT;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ENCHANTMENT");
        Holder.Reference efficiency = BlockEntityExtensionKt.holderLookup(blockEntity, resourceKey).getOrThrow(Enchantments.EFFICIENCY);
        Intrinsics.checkNotNull((Object)efficiency);
        int efficiencyLevel = this.getEnchantmentLevel((Holder<Enchantment>)((Holder)efficiency));
        return super.getBreakSpeed() * (float)(efficiencyLevel + 1);
    }

    public boolean canBreak(@NotNull BlockState stateToBreak, float blockHardness) {
        Intrinsics.checkNotNullParameter((Object)stateToBreak, (String)"stateToBreak");
        return DrillBlockEntity.isBreakable((BlockState)stateToBreak, (float)blockHardness);
    }

    public void onBlockBroken(@Nullable BlockState stateToBreak) {
        if (this.optimiseCobbleGen(stateToBreak)) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Level nonNullLevel = level;
        Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)((Vec3i)this.breakingPos)), (RandomSource)nonNullLevel.random, (float)0.125f);
        BlockHelper.destroyBlockAs((Level)nonNullLevel, (BlockPos)this.breakingPos, null, (ItemStack)EnchantedItemFactory.INSTANCE.getPickaxeItemStack(this.getEnchantments()), (float)1.0f, arg_0 -> EnchantableDrillBlockEntity.onBlockBroken$lambda$0(nonNullLevel, vec, arg_0));
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getEnchantments().entrySet().isEmpty()) {
            return false;
        }
        for (Object2IntMap.Entry instance : this.getEnchantments().entrySet()) {
            CreateLang.text((String)Strings.repeat((char)' ', (int)0)).add(Enchantment.getFullname((Holder)((Holder)instance.getKey()), (int)instance.getIntValue())).forGoggles(tooltip);
        }
        return true;
    }

    protected void read(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.readEnchantments(compound, registries);
        super.read(compound, registries, clientPacket);
    }

    public void write(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.writeEnchantments(compound, registries);
        super.write(compound, registries, clientPacket);
    }

    @Override
    @NotNull
    public ItemEnchantments getEnchantments() {
        return this.$$delegate_0.getEnchantments();
    }

    @Override
    public void setEnchantment(@NotNull ItemEnchantments enchantments) {
        Intrinsics.checkNotNullParameter((Object)enchantments, (String)"enchantments");
        this.$$delegate_0.setEnchantment(enchantments);
    }

    @Override
    public int getEnchantmentLevel(@NotNull Holder<Enchantment> enchantment) {
        Intrinsics.checkNotNullParameter(enchantment, (String)"enchantment");
        return this.$$delegate_0.getEnchantmentLevel(enchantment);
    }

    @Override
    public void readEnchantments(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0.readEnchantments(tag, provider);
    }

    @Override
    public void writeEnchantments(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0.writeEnchantments(tag, provider);
    }

    private static final void onBlockBroken$lambda$0(Level $nonNullLevel, Vec3 $vec, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            return;
        }
        if (!$nonNullLevel.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            return;
        }
        if ($nonNullLevel.restoringBlockSnapshots) {
            return;
        }
        ItemEntity entity = new ItemEntity($nonNullLevel, $vec.x, $vec.y, $vec.z, stack);
        entity.setDefaultPickUpDelay();
        entity.setDeltaMovement(Vec3.ZERO);
        $nonNullLevel.addFreshEntity((Entity)entity);
    }
}

