/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars.mixin;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.nuggets.client.overlay.IWorldTooltipProvider;
import es.degrassi.custommachineryars.Registration;
import es.degrassi.custommachineryars.components.ISourceCapExtension;
import es.degrassi.custommachineryars.util.IWandableMachineTile;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CustomMachineTile.class})
public abstract class CustomMachineTileMixin
extends MachineTile
implements IWandable,
IWorldTooltipProvider,
IWandableMachineTile {
    @Unique
    private BlockPos cma$toPos;
    @Unique
    private BlockPos cma$fromPos;
    @Unique
    private static final String cma$TO = "to_";
    @Unique
    private static final String cma$FROM = "from";

    @Shadow
    public abstract IMachineComponentManager getComponentManager();

    public CustomMachineTileMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void cma$saveAdditional(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        if (this.cma$toPos != null) {
            NBTUtil.storeBlockPos((CompoundTag)nbt, (String)cma$TO, (BlockPos)this.cma$toPos.immutable());
        } else {
            NBTUtil.removeBlockPos((CompoundTag)nbt, (String)cma$TO);
        }
        if (this.cma$fromPos != null) {
            NBTUtil.storeBlockPos((CompoundTag)nbt, (String)cma$FROM, (BlockPos)this.cma$fromPos.immutable());
        } else {
            NBTUtil.removeBlockPos((CompoundTag)nbt, (String)cma$FROM);
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void cma$loadAdditional(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        this.cma$toPos = null;
        this.cma$fromPos = null;
        if (NBTUtil.hasBlockPos((CompoundTag)nbt, (String)cma$TO)) {
            this.cma$toPos = NBTUtil.getBlockPos((CompoundTag)nbt, (String)cma$TO);
        }
        if (NBTUtil.hasBlockPos((CompoundTag)nbt, (String)cma$FROM)) {
            this.cma$fromPos = NBTUtil.getBlockPos((CompoundTag)nbt, (String)cma$FROM);
        }
    }

    @Inject(method={"getUpdateTag"}, at={@At(value="RETURN")}, cancellable=true)
    private void cma$getUpdateTag(CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag nbt = (CompoundTag)cir.getReturnValue();
        NBTUtil.storeBlockPos((CompoundTag)nbt, (String)cma$TO, (BlockPos)this.cma$toPos);
        NBTUtil.storeBlockPos((CompoundTag)nbt, (String)cma$FROM, (BlockPos)this.cma$fromPos);
        cir.setReturnValue((Object)nbt);
    }

    @Override
    public BlockPos cma$getToPos() {
        return this.cma$toPos;
    }

    @Override
    public BlockPos cma$getFromPos() {
        return this.cma$fromPos;
    }

    @Override
    public void cma$setFromPos(BlockPos pos) {
        this.cma$fromPos = pos;
        Objects.requireNonNull(this.getLevel()).sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void cma$setToPos(BlockPos pos) {
        this.cma$toPos = pos;
        Objects.requireNonNull(this.getLevel()).sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (this.level == null || storedPos == null || this.level.isClientSide || storedPos.equals((Object)this.getBlockPos()) || !(this.level.getBlockEntity(storedPos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(storedPos) instanceof CustomMachineTile)) {
            return;
        }
        this.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
            if (this.cma$setSendTo(storedPos.immutable())) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"custommachineryars.connections.send", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
                ParticleUtil.beam((BlockPos)storedPos, (BlockPos)this.worldPosition, (Level)this.level);
            } else {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"custommachineryars.connections.fail"));
            }
        });
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (this.level == null || storedPos == null || storedPos.equals((Object)this.getBlockPos()) || this.level.getBlockEntity(storedPos) instanceof RelayTile || !(this.level.getBlockEntity(storedPos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(storedPos) instanceof CustomMachineTile)) {
            return;
        }
        this.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
            if (this.cma$setTakeFrom(storedPos.immutable())) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"custommachineryars.connections.take", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
            } else {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"custommachineryars.connections.fail"));
            }
        });
    }

    public IWandable.Result onClearConnections(Player playerEntity) {
        this.cma$clearPos();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.cleared"));
        return IWandable.Result.CLEAR;
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.cma$toPos != null) {
            list.add(ColorPos.centered((BlockPos)this.cma$toPos, (ParticleColor)ParticleColor.TO_HIGHLIGHT));
        }
        if (this.cma$fromPos != null) {
            list.add(ColorPos.centered((BlockPos)this.cma$fromPos, (ParticleColor)ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    @Unique
    public int cma$getMaxDistance() {
        return 30;
    }

    @Unique
    public boolean cma$setTakeFrom(BlockPos pos) {
        if (BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.worldPosition) > (double)this.cma$getMaxDistance() || pos.equals((Object)this.getBlockPos())) {
            return false;
        }
        this.cma$setFromPos(pos);
        return true;
    }

    @Unique
    public boolean cma$setSendTo(BlockPos pos) {
        if (BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.worldPosition) > (double)this.cma$getMaxDistance() || pos.equals((Object)this.getBlockPos()) || !(Objects.requireNonNull(this.level).getBlockEntity(pos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(pos) instanceof CustomMachineTile)) {
            return false;
        }
        this.cma$setToPos(pos);
        return true;
    }

    @Unique
    public void cma$clearPos() {
        this.cma$setToPos(null);
        this.cma$setFromPos(null);
    }

    @Override
    public int cma$transferSource(ISourceCapExtension from, ISourceCapExtension to) {
        int transferRate = this.cma$getTransferRate(from, to);
        if (transferRate <= 0) {
            return 0;
        }
        from.removeSource(transferRate);
        to.addSource(transferRate);
        this.getComponentManager().markDirty();
        return transferRate;
    }

    @Override
    public int cma$transferSource(ISourceTile from, ISourceCapExtension to) {
        int transferRate = this.cma$getTransferRate(from, to);
        if (transferRate <= 0) {
            return 0;
        }
        from.removeSource(transferRate);
        to.addSource(transferRate);
        this.getComponentManager().markDirty();
        return transferRate;
    }

    @Override
    public int cma$transferSource(ISourceCapExtension from, ISourceTile to) {
        int transferRate = this.cma$getTransferRate(from, to);
        if (transferRate <= 0) {
            return 0;
        }
        from.removeSource(transferRate);
        to.addSource(transferRate);
        this.getComponentManager().markDirty();
        return transferRate;
    }

    @Override
    public int cma$transferSource(ISourceTile from, ISourceTile to) {
        int transferRate = this.cma$getTransferRate(from, to);
        if (transferRate <= 0) {
            return 0;
        }
        from.removeSource(transferRate);
        to.addSource(transferRate);
        this.getComponentManager().markDirty();
        return transferRate;
    }

    @Override
    public int cma$getTransferRate(ISourceCapExtension from, ISourceCapExtension to) {
        return Math.min(Math.min(from.getTransferRate(), from.getSource()), to.getMaxSource() - to.getSource());
    }

    @Override
    public int cma$getTransferRate(ISourceTile from, ISourceCapExtension to) {
        return Math.min(Math.min(from.getTransferRate(), from.getSource()), to.getMaxSource() - to.getSource());
    }

    @Override
    public int cma$getTransferRate(ISourceCapExtension from, ISourceTile to) {
        return Math.min(Math.min(from.getTransferRate(), from.getSource()), to.getMaxSource() - to.getSource());
    }

    @Override
    public int cma$getTransferRate(ISourceTile from, ISourceTile to) {
        return Math.min(Math.min(from.getTransferRate(), from.getSource()), to.getMaxSource() - to.getSource());
    }

    public void getTooltip(List<Component> tooltip) {
        tooltip.clear();
        this.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
            if (this.cma$toPos == null) {
                tooltip.add((Component)Component.translatable((String)"custommachineryars.relay.no_to"));
            } else {
                tooltip.add((Component)Component.translatable((String)"custommachineryars.relay.one_to", (Object[])new Object[]{1}));
            }
            if (this.cma$fromPos == null) {
                tooltip.add((Component)Component.translatable((String)"custommachineryars.relay.no_from"));
            } else {
                tooltip.add((Component)Component.translatable((String)"custommachineryars.relay.one_from", (Object[])new Object[]{1}));
            }
        });
    }
}

