/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue;

import com.cmdpro.databank.dialogue.DialogueChoice;
import com.cmdpro.databank.dialogue.DialogueSpeaker;
import com.cmdpro.databank.dialogue.DialogueTree;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class DialogueEntry {
    public DialogueTree tree;
    public String id;
    public Component text;
    public String speaker;
    public List<DialogueChoice> choices;
    public ResourceLocation style;
    public double speed;
    public Optional<Integer> closeMenuChoice;
    public static final Codec<DialogueEntry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ComponentSerialization.CODEC.fieldOf("text").forGetter(obj -> obj.text), (App)Codec.STRING.fieldOf("speaker").forGetter(obj -> obj.speaker), (App)DialogueChoice.CODEC.listOf().fieldOf("choices").forGetter(obj -> obj.choices), (App)ResourceLocation.CODEC.fieldOf("style").forGetter(obj -> obj.style), (App)Codec.DOUBLE.optionalFieldOf("speed", (Object)1.0).forGetter(obj -> obj.speed), (App)Codec.INT.optionalFieldOf("closeMenuChoice").forGetter(obj -> obj.closeMenuChoice)).apply((Applicative)builder, DialogueEntry::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DialogueEntry> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
        ComponentSerialization.STREAM_CODEC.encode(buf, (Object)obj.text);
        buf.writeUtf(obj.speaker);
        buf.writeCollection(obj.choices, (buf2, obj2) -> DialogueChoice.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), obj2));
        buf.writeResourceLocation(obj.style);
        buf.writeDouble(obj.speed);
        buf.writeOptional(obj.closeMenuChoice, FriendlyByteBuf::writeInt);
    }, buf -> {
        Component text = (Component)ComponentSerialization.STREAM_CODEC.decode(buf);
        String speaker = buf.readUtf();
        List choices = buf.readList(buf2 -> (DialogueChoice)DialogueChoice.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        ResourceLocation style = buf.readResourceLocation();
        double speed = buf.readDouble();
        Optional closeMenuChoice = buf.readOptional(FriendlyByteBuf::readInt);
        return new DialogueEntry(text, speaker, choices, style, speed, closeMenuChoice);
    });

    public DialogueEntry(Component text, String speaker, List<DialogueChoice> choices, ResourceLocation style, double speed, Optional<Integer> closeMenuChoice) {
        this.text = text;
        this.speaker = speaker;
        this.choices = choices;
        this.style = style;
        this.speed = speed;
        this.closeMenuChoice = closeMenuChoice;
        for (DialogueChoice i : choices) {
            i.entry = this;
        }
    }

    public DialogueSpeaker getSpeaker() {
        return this.tree.speakers.get(this.speaker);
    }
}

