/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CollisionTestCube {
    public Vector3f center;
    public Vector3f size;
    public Quaternionf rotation;

    public CollisionTestCube(AABB aabb) {
        this(aabb, new Quaternionf());
    }

    public CollisionTestCube(AABB aabb, Quaternionf rotation) {
        this(aabb.getCenter().toVector3f(), new Vec3(aabb.getXsize(), aabb.getYsize(), aabb.getZsize()).toVector3f(), rotation);
    }

    public CollisionTestCube(Vector3f center, Vector3f size, Quaternionf rotation) {
        this.center = center;
        this.size = size;
        this.rotation = rotation;
    }

    public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, Level level) {
        return this.getEntitiesOfClass(entityClass, level, false, EntitySelector.NO_SPECTATORS);
    }

    public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, Level level, boolean alignEntityHitboxes) {
        return this.getEntitiesOfClass(entityClass, level, alignEntityHitboxes, EntitySelector.NO_SPECTATORS);
    }

    public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, Level level, boolean alignEntityHitboxes, Predicate<? super T> filter) {
        float testAABBSize = Math.max(Math.max(this.size.x, this.size.y), this.size.z) * 2.0f;
        return level.getEntitiesOfClass(entityClass, AABB.ofSize((Vec3)new Vec3((double)this.center.x, (double)this.center.y, (double)this.center.z), (double)testAABBSize, (double)testAABBSize, (double)testAABBSize), entity -> {
            if (filter.test(entity)) {
                CollisionTestCube cube = new CollisionTestCube(entity.getBoundingBox(), alignEntityHitboxes ? new Quaternionf((Quaternionfc)this.rotation) : new Quaternionf());
                return cube.intersects(this);
            }
            return false;
        });
    }

    public boolean intersects(CollisionTestCube other) {
        float[] projB;
        float[] projA;
        Vector3f[] axesA = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation), new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation), new Vector3f(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation)};
        Vector3f[] axesB = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)other.rotation), new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)other.rotation), new Vector3f(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)other.rotation)};
        for (Vector3f i : axesA) {
            projA = this.project(i);
            if (!(projA[1] < (projB = other.project(i))[0] - 1.0E-6f) && !(projB[1] < projA[0] - 1.0E-6f)) continue;
            return false;
        }
        for (Vector3f i : axesB) {
            projA = this.project(i);
            if (!(projA[1] < (projB = other.project(i))[0] - 1.0E-6f) && !(projB[1] < projA[0] - 1.0E-6f)) continue;
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Vector3f axis = new Vector3f((Vector3fc)axesA[i].cross((Vector3fc)axesB[j]));
                if (axis.length() < 1.0E-6f) continue;
                axis.normalize();
                float[] projA2 = this.project(axis);
                float[] projB2 = other.project(axis);
                if (!(projA2[1] < projB2[0] - 1.0E-6f) && !(projB2[1] < projA2[0] - 1.0E-6f)) continue;
                return false;
            }
        }
        return true;
    }

    public Vector3f getHalfSize() {
        return new Vector3f((Vector3fc)this.size).mul(0.5f);
    }

    public float[] project(Vector3f axis) {
        Vector3f halfSize = this.getHalfSize();
        Vector3f axisX = new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        Vector3f axisY = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        Vector3f axisZ = new Vector3f(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation);
        float pX = Math.abs(halfSize.x * axisX.dot((Vector3fc)axis));
        float pY = Math.abs(halfSize.y * axisY.dot((Vector3fc)axis));
        float pZ = Math.abs(halfSize.z * axisZ.dot((Vector3fc)axis));
        float r = pX + pY + pZ;
        float centerProjection = this.center.dot((Vector3fc)axis);
        float minProj = centerProjection - r;
        float maxProj = centerProjection + r;
        return new float[]{minProj, maxProj};
    }
}

