/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailTickHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TrailRender {
    public Vec3 offset = new Vec3(0.0, 0.0, 0.0);
    public Vec3 position;
    public int segments;
    public int time;
    public float size;
    public ResourceLocation texture;
    public RenderType renderType;
    private final List<Vec3> positions = new ArrayList<Vec3>();
    private boolean shrink;

    public TrailRender(Vec3 position, int segments, int time, float size, ResourceLocation texture) {
        this(position, segments, time, size, texture, RenderType.ENTITY_CUTOUT);
    }

    public TrailRender(Vec3 position, int segments, int time, float size, ResourceLocation texture, Function<ResourceLocation, RenderType> renderType) {
        this(position, segments, time, size, texture, renderType.apply(texture));
    }

    public TrailRender(Vec3 position, int segments, int time, float size, ResourceLocation texture, RenderType renderType) {
        this.position = position;
        this.segments = segments;
        this.time = time;
        this.size = size;
        this.texture = texture;
        this.renderType = renderType;
        if (this.segments > this.time) {
            throw new RuntimeException("Segments in a trail cannot be greater than time");
        }
    }

    public TrailRender setShrink(boolean shrink) {
        this.shrink = shrink;
        return this;
    }

    public TrailRender startTicking() {
        TrailTickHandler.addTrail(this);
        return this;
    }

    public TrailRender stopTicking() {
        TrailTickHandler.removeTrail(this);
        return this;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, int packedLight, int color) {
        this.render(pPoseStack, pBufferSource, packedLight, new Color(color));
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, int packedLight, Color color) {
        this.render(pPoseStack, pBufferSource, packedLight, ColorGradient.singleColor(color));
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, int packedLight, ColorGradient gradient) {
        if (this.positions.isEmpty()) {
            return;
        }
        ArrayList<Vec3> positions = new ArrayList<Vec3>(this.positions);
        ArrayList<Vector3f> segs = new ArrayList<Vector3f>();
        segs.add(((Vec3)positions.getFirst()).add(this.offset).toVector3f());
        for (int i = 1; i < this.segments; ++i) {
            int index = (int)((float)this.time * ((float)i / (float)this.segments));
            if (positions.size() - 1 < index) continue;
            segs.add(((Vec3)positions.get(index)).add(this.offset).toVector3f());
        }
        segs.add(((Vec3)positions.getLast()).add(this.offset).toVector3f());
        VertexConsumer consumer = pBufferSource.getBuffer(this.renderType);
        int highestSeg = segs.size() - 1;
        Vector3f previousCenter = null;
        for (int i = 0; i < segs.size(); ++i) {
            Vector3f nextSeg;
            Vector3f seg = (Vector3f)segs.get(i);
            Vector3f vector3f = nextSeg = segs.size() > i + 1 ? (Vector3f)segs.get(i + 1) : null;
            if (nextSeg == null) continue;
            if (previousCenter == null) {
                previousCenter = new Vector3f((Vector3fc)seg).sub((Vector3fc)new Vector3f((Vector3fc)nextSeg).sub((Vector3fc)seg).normalize());
            }
            float wCur = this.shrink ? 1.0f - (float)i / (float)highestSeg : 1.0f;
            float wNext = this.shrink ? 1.0f - (float)(i + 1) / (float)highestSeg : 1.0f;
            Vector3f currentTrailUpper = this.getTrailPos(seg, previousCenter, this.size * wCur);
            Vector3f currentTrailLower = this.getTrailPos(seg, previousCenter, -this.size * wCur);
            Vector3f nextTrailUpper = this.getTrailPos(nextSeg, seg, this.size * wNext);
            Vector3f nextTrailLower = this.getTrailPos(nextSeg, seg, -this.size * wNext);
            float uCur = (float)i / (float)highestSeg;
            float uNext = (float)(i + 1) / (float)highestSeg;
            int colorCur = ((Color)gradient.getValue((float)i / (float)highestSeg)).getRGB();
            int colorNext = ((Color)gradient.getValue((float)(i + 1) / (float)highestSeg)).getRGB();
            this.addVertex(consumer, pPoseStack, currentTrailUpper, uCur, 0.0f + (1.0f - wCur) / 2.0f, colorCur, packedLight);
            this.addVertex(consumer, pPoseStack, nextTrailUpper, uNext, 0.0f + (1.0f - wNext) / 2.0f, colorNext, packedLight);
            this.addVertex(consumer, pPoseStack, nextTrailLower, uNext, 1.0f - (1.0f - wNext) / 2.0f, colorNext, packedLight);
            this.addVertex(consumer, pPoseStack, currentTrailLower, uCur, 1.0f - (1.0f - wCur) / 2.0f, colorCur, packedLight);
            previousCenter = seg;
        }
    }

    public void tick() {
        if (this.positions.isEmpty() || this.positions.getFirst().distanceTo(this.position) > 0.01) {
            this.positions.addFirst(this.position);
        } else if (!this.positions.isEmpty()) {
            this.positions.removeLast();
        }
        while (this.positions.size() > this.time) {
            this.positions.removeLast();
        }
    }

    public void reset() {
        this.positions.clear();
    }

    public int getPositionCount() {
        return this.positions.size();
    }

    public Vec3 getPosition(int index) {
        return this.positions.get(index);
    }

    private Vector3f getTrailPos(Vector3f trailCenter, Vector3f previousCenter, float size) {
        float sizeDiff = size / 2.0f;
        Vec2 rot = TrailRender.calculateRotationVector(new Vec3((double)trailCenter.x, (double)trailCenter.y, (double)trailCenter.z), new Vec3((double)previousCenter.x, (double)previousCenter.y, (double)previousCenter.z));
        Quaternionf quaternionf2 = new Quaternionf();
        quaternionf2.rotateY((float)Math.toRadians(-rot.y + 180.0f));
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vector3f vecToCamera = camera.getPosition().toVector3f().sub((Vector3fc)trailCenter).normalize();
        Vector3f vecToPrev = new Vector3f((Vector3fc)previousCenter).sub((Vector3fc)trailCenter).normalize();
        return new Vector3f((Vector3fc)trailCenter).add((Vector3fc)new Vector3f((Vector3fc)vecToCamera).cross((Vector3fc)vecToPrev).normalize().mul(sizeDiff));
    }

    private VertexConsumer addVertex(VertexConsumer consumer, PoseStack stack, Vector3f pos, float u, float v, int color, int packedLight) {
        return consumer.addVertex(stack.last(), pos).setColor(color).setUv(u, v).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static Vec2 calculateRotationVector(Vec3 pVec, Vec3 pTarget) {
        double d0 = pTarget.x - pVec.x;
        double d1 = pTarget.y - pVec.y;
        double d2 = pTarget.z - pVec.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
    }
}

