/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.mixin;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.hidden.types.BlockHiddenType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin {
    @Inject(method={"getShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getShape(BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext entityShapeContext;
        Entity contextEntity;
        if (context instanceof EntityCollisionContext && (contextEntity = (entityShapeContext = (EntityCollisionContext)context).getEntity()) instanceof Player) {
            Player player = (Player)contextEntity;
            BlockStateBaseMixin blockStateBaseMixin = this;
            if (blockStateBaseMixin instanceof BlockState) {
                BlockState state = (BlockState)blockStateBaseMixin;
                if (player.level().isClientSide) {
                    block = BlockHiddenType.getHiddenBlockClient(state);
                    if (block != null && block != state.getBlock()) {
                        cir.setReturnValue((Object)DatabankUtils.changeBlockType(state, block).getShape(level, pos, context));
                    }
                } else {
                    block = BlockHiddenType.getHiddenBlock(state, player);
                    if (block != null && block != state.getBlock()) {
                        cir.setReturnValue((Object)DatabankUtils.changeBlockType(state, block).getShape(level, pos, context));
                    }
                }
            }
        }
    }
}

