/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model.entity;

import com.cmdpro.databank.model.BaseDatabankModel;
import com.cmdpro.databank.model.ModelPose;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class DatabankEntityModel<T extends Entity>
extends BaseDatabankModel<T> {
    public void render(T pEntity, float partialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult) {
        this.renderModel(pEntity, partialTick, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor, normalMult);
    }

    public void renderModel(T pEntity, float partialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult) {
        for (ModelPose.ModelPosePart i : this.modelPose.parts) {
            this.renderPartAndChildren(pEntity, partialTick, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor, i, normalMult);
        }
    }

    @Override
    public RenderType getRenderType(T obj) {
        boolean bodyVisible = this.isBodyVisible(obj);
        boolean translucent = !bodyVisible && !obj.isInvisibleTo((Player)Minecraft.getInstance().player);
        boolean glowing = Minecraft.getInstance().shouldEntityAppearGlowing(obj);
        ResourceLocation resourcelocation = this.getTextureLocation();
        if (translucent) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (bodyVisible) {
            return super.getRenderType(obj);
        }
        return glowing ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    protected boolean isBodyVisible(T livingEntity) {
        return !livingEntity.isInvisible();
    }
}

