/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.networking.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RemoveDimensionS2CPacket(ResourceKey<Level> key) implements Message
{
    public static final CustomPacketPayload.Type<RemoveDimensionS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("remove_dimension"));

    public static RemoveDimensionS2CPacket read(FriendlyByteBuf buf) {
        ResourceKey key = buf.readResourceKey(Registries.DIMENSION);
        return new RemoveDimensionS2CPacket((ResourceKey<Level>)key);
    }

    public static void write(FriendlyByteBuf buf, RemoveDimensionS2CPacket obj) {
        buf.writeResourceKey(obj.key);
    }

    public CustomPacketPayload.Type<RemoveDimensionS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        ClientHandler.removeDimension(this.key);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void removeDimension(ResourceKey<Level> key) {
            Minecraft.getInstance().player.connection.levels().remove(key);
        }
    }
}

