/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.deepdarkdimdungeons.portal;

import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class DimDungeonsIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemStack createActivatedPortalKey(ServerLevel serverLevel, int level) {
        try {
            ItemPortalKey keyItem = (ItemPortalKey)serverLevel.registryAccess().registryOrThrow(Registries.ITEM).get(ResourceLocation.parse((String)"dimdungeons:item_portal_key"));
            if (keyItem == null) {
                LOGGER.error("Could not find dimdungeons:portal_key in item registry");
                return ItemStack.EMPTY;
            }
            ItemStack keyStack = new ItemStack((ItemLike)keyItem);
            if (level == 1) {
                keyItem.activateKeyLevel1(serverLevel.getServer(), keyStack, 0);
            } else if (level == 2) {
                keyItem.activateKeyLevel2(serverLevel.getServer(), keyStack);
            }
            return keyStack;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create activated portal key", (Throwable)e);
            return ItemStack.EMPTY;
        }
    }

    public static BlockPos getPortalDestination(ItemStack keyStack) {
        try {
            ItemPortalKey keyItem = (ItemPortalKey)keyStack.getItem();
            float warpX = keyItem.getWarpX(keyStack);
            float warpZ = keyItem.getWarpZ(keyStack);
            boolean isActivated = keyItem.isActivated(keyStack);
            if (!isActivated) {
                return new BlockPos(0, 55, 0);
            }
            return new BlockPos((int)warpX, 55, (int)warpZ);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get portal destination", (Throwable)e);
            return new BlockPos(0, 55, 0);
        }
    }

    public static DungeonGenData generateDungeon(ServerLevel serverLevel, BlockPos returnPoint) {
        try {
            ItemStack fakeKey = DimDungeonsIntegration.createActivatedPortalKey(serverLevel, 1);
            if (fakeKey.isEmpty()) {
                LOGGER.error("Failed to create portal key for dungeon generation");
                return null;
            }
            DungeonGenData dungeonData = DimDungeonsIntegration.triggerDungeonGeneration(serverLevel, fakeKey, returnPoint);
            if (dungeonData != null) {
                return dungeonData;
            }
            LOGGER.error("Failed to trigger dungeon generation");
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error during dungeon generation", (Throwable)e);
            return null;
        }
    }

    private static DungeonGenData triggerDungeonGeneration(ServerLevel serverLevel, ItemStack fakeKey, BlockPos returnPoint) {
        try {
            ServerLevel dungeonLevel = DungeonUtils.getDungeonWorld((MinecraftServer)serverLevel.getServer());
            if (dungeonLevel == null) {
                return null;
            }
            Item item = fakeKey.getItem();
            if (!(item instanceof ItemPortalKey)) {
                LOGGER.error("Could not find dimdungeons:portal_key in item registry");
                return null;
            }
            ItemPortalKey keyItem = (ItemPortalKey)item;
            long topLeftX = keyItem.getDungeonTopLeftX(fakeKey);
            long topLeftZ = keyItem.getDungeonTopLeftZ(fakeKey);
            if (topLeftX == Long.MIN_VALUE || topLeftZ == Long.MIN_VALUE) {
                LOGGER.error("Failed to get dungeon top-left coordinates from portal key");
                return null;
            }
            long entranceX = topLeftX + 128L;
            long entranceZ = topLeftZ + 176L;
            if (Math.abs(entranceX) > 30000000L || Math.abs(entranceZ) > 30000000L) {
                LOGGER.error("Dungeon entrance coordinates out of bounds: ({}, {})", (Object)entranceX, (Object)entranceZ);
                return null;
            }
            DungeonGenData dungeonGenData = DungeonGenData.Create().setKeyItem(fakeKey).setTheme(0).setReturnPoint(returnPoint, serverLevel.dimension().location().toString()).setReturnPoint(returnPoint, serverLevel.dimension().location().toString());
            boolean dungeonExists = DungeonUtils.dungeonAlreadyExistsHere((Level)dungeonLevel, (long)entranceX, (long)entranceZ);
            ItemPortalKey.setDungeonBuilt((ItemStack)fakeKey);
            if (!dungeonExists) {
                DungeonPlacement.beginDesignAndBuild((ServerLevel)dungeonLevel, (long)topLeftX, (long)topLeftZ, (DungeonGenData)dungeonGenData);
            }
            return dungeonGenData;
        }
        catch (Exception e) {
            LOGGER.error("Error triggering dungeon generation", (Throwable)e);
            return null;
        }
    }
}

