/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.deepdarkdimdungeons.portal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PortalDestinationManager
extends SavedData {
    private static final String DATA_NAME = "deepdarkdimdungeons_portal_destinations";
    private final Map<BlockPos, BlockPos> portalDestinations = new HashMap<BlockPos, BlockPos>();

    public PortalDestinationManager() {
    }

    public PortalDestinationManager(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadFromTag(tag);
    }

    public static PortalDestinationManager get(ServerLevel level) {
        return (PortalDestinationManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(PortalDestinationManager::new, PortalDestinationManager::new), DATA_NAME);
    }

    public void setPortalDestination(BlockPos portalPos, BlockPos destination) {
        this.portalDestinations.put(portalPos, destination);
        this.setDirty();
    }

    public BlockPos getPortalDestination(BlockPos portalPos) {
        return this.portalDestinations.get(portalPos);
    }

    public void removePortalDestination(BlockPos portalPos) {
        this.portalDestinations.remove(portalPos);
        this.setDirty();
    }

    public void setFrameDestination(BlockPos bottomLeft, int width, int height, Direction.Axis axis, BlockPos destination) {
        Direction rightDir = axis == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                BlockPos portalPos = bottomLeft.relative(rightDir, x + 1).above(y + 1);
                this.setPortalDestination(portalPos, destination);
            }
        }
    }

    private void loadFromTag(CompoundTag tag) {
        this.portalDestinations.clear();
        ListTag portalList = tag.getList("portals", 10);
        for (int i = 0; i < portalList.size(); ++i) {
            CompoundTag portalTag = portalList.getCompound(i);
            BlockPos portalPos = new BlockPos(portalTag.getInt("portal_x"), portalTag.getInt("portal_y"), portalTag.getInt("portal_z"));
            BlockPos destination = new BlockPos(portalTag.getInt("dest_x"), portalTag.getInt("dest_y"), portalTag.getInt("dest_z"));
            this.portalDestinations.put(portalPos, destination);
        }
    }

    @Nonnull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag portalList = new ListTag();
        for (Map.Entry<BlockPos, BlockPos> entry : this.portalDestinations.entrySet()) {
            CompoundTag portalTag = new CompoundTag();
            BlockPos portal = entry.getKey();
            BlockPos destination = entry.getValue();
            portalTag.putInt("portal_x", portal.getX());
            portalTag.putInt("portal_y", portal.getY());
            portalTag.putInt("portal_z", portal.getZ());
            portalTag.putInt("dest_x", destination.getX());
            portalTag.putInt("dest_y", destination.getY());
            portalTag.putInt("dest_z", destination.getZ());
            portalList.add((Object)portalTag);
        }
        tag.put("portals", (Tag)portalList);
        return tag;
    }
}

