/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockGoldPortal
extends BaseEntityBlock {
    public static String REG_NAME = "block_gold_portal";
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final TagKey<Block> tag_portal_frame_blocks = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"portal_frame_blocks"));

    protected MapCodec<? extends BlockGoldPortal> codec() {
        throw new AssertionError((Object)"Implement block codec!");
    }

    public BlockGoldPortal() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.BLOCK).randomTicks().strength(9999.0f).sound(SoundType.GLASS).noCollission().lightLevel(p -> 15));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!this.checkPortalIntegrity(state, (LevelAccessor)worldIn, pos)) {
            worldIn.destroyBlock(pos, false);
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.checkPortalIntegrity(state, (LevelAccessor)worldIn, pos)) {
            worldIn.destroyBlock(pos, false);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.checkPortalIntegrity(stateIn, worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tile;
        if (worldIn.isClientSide) {
            return;
        }
        if (!(entityIn instanceof ServerPlayer)) {
            return;
        }
        if (!entityIn.isPassenger() && !entityIn.isVehicle() && (tile = worldIn.getBlockEntity(pos)) != null && tile instanceof TileEntityGoldPortal) {
            TileEntityPortalKeyhole keyhole;
            TileEntityGoldPortal te = (TileEntityGoldPortal)worldIn.getBlockEntity(pos);
            BlockPos destination = te.getDestination();
            float warpX = destination.getX();
            float warpY = destination.getY();
            float warpZ = destination.getZ();
            ResourceKey<Level> destDim = te.getDestinationDimension();
            int cooldown = te.getCooldown();
            if (!entityIn.canChangeDimensions(worldIn, (Level)entityIn.getServer().getLevel(te.getDestinationDimension()))) {
                return;
            }
            int currentTick = worldIn.getServer().getTickCount();
            if (!te.needsUpdateThisTick(currentTick)) {
                return;
            }
            if (cooldown > 0) {
                te.setCooldown(cooldown - 1, worldIn, pos, currentTick);
                return;
            }
            te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
            if (destDim.location().getPath().equals("dungeon_dimension")) {
                if (DungeonConfig.hardcoreMode && (keyhole = this.findKeyholeForThisPortal(state, (LevelAccessor)worldIn, pos)) != null) {
                    keyhole.removeContents();
                    BlockState emptyState = worldIn.getBlockState(keyhole.getBlockPos());
                    worldIn.setBlockAndUpdate(keyhole.getBlockPos(), (BlockState)((BlockState)emptyState.setValue((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(false)));
                }
                if (DungeonConfig.disableAllDungeons) {
                    te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
                    DungeonUtils.giveSecuritySystemPrompt((Player)((ServerPlayer)entityIn), "security.dimdungeons.disabled_dungeon_dimension");
                    return;
                }
            }
            if (destDim.location().getPath().equals("build_dimension")) {
                keyhole = this.findKeyholeForThisPortal(state, (LevelAccessor)worldIn, pos);
                if (keyhole == null) {
                    DimDungeons.logMessageError("Unable to check the permissions for a personal build dimension because the keyhole is missing.");
                } else {
                    ItemStack key = keyhole.getObjectInserted();
                    if (key.getItem() == ItemRegistrar.ITEM_BUILD_KEY.get()) {
                        DungeonKeyDataComponentRecord itemData = (DungeonKeyDataComponentRecord)key.get(DimDungeons.DUNGEON_KEY_DATA);
                        ChunkPos cpos = new ChunkPos((int)itemData.dest_x(), (int)itemData.dest_z());
                        if (!PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(entityIn.getServer())).isPlayerAllowedInPersonalDimension((Player)((ServerPlayer)entityIn), cpos)) {
                            te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
                            DungeonUtils.giveSecuritySystemPrompt((Player)((ServerPlayer)entityIn), "security.dimdungeons.player_failed_teleport");
                            return;
                        }
                        DimDungeons.logMessageInfo("You passed the permissions check!");
                    } else {
                        DimDungeons.logMessageError("Unable to check the permissions for a personal build dimension because the keyhole does not contain a key?");
                    }
                }
                if (DungeonConfig.disablePersonalBuildDimension) {
                    te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
                    DungeonUtils.giveSecuritySystemPrompt((Player)((ServerPlayer)entityIn), "security.dimdungeons.disabled_build_dimension");
                    return;
                }
            }
            DimDungeons.logMessageInfo("Player is using a gold portal to teleport to (" + warpX + " " + warpY + " " + warpZ + ") in dimension " + destDim.location().toString() + ".");
            ServerPlayer player = (ServerPlayer)entityIn;
            this.actuallyPerformTeleport(player, player.getServer().getLevel(te.getDestinationDimension()), warpX, warpY, warpZ, this.getReturnYawForDirection(te.getExitDirection()));
        }
    }

    protected float getReturnYawForDirection(Direction exitFacing) {
        switch (exitFacing) {
            case SOUTH: {
                return 0.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 180.0f;
    }

    protected Entity actuallyPerformTeleport(ServerPlayer player, ServerLevel dim, double x, double y, double z, float yaw) {
        float destPitch = 0.0f;
        float destYaw = yaw;
        List multiplayerHardcore = null;
        if (DungeonUtils.isDimensionDungeon((Level)dim)) {
            DungeonRoom entrance;
            ChunkPos cpos = new ChunkPos(new BlockPos((int)(x -= 0.0), (int)y, (int)(z += 1.0)));
            if (DungeonConfig.hardcoreMode) {
                Vec3 pos = player.getPosition(0.0f);
                int range = DungeonConfig.hardcoreMultiplayerRadius;
                multiplayerHardcore = player.level().getEntitiesOfClass(ServerPlayer.class, new AABB(pos.add((double)(-range), (double)(-range), (double)(-range)), pos.add((double)(range + 1), (double)(range + 1), (double)(range + 1))), this.getSelector());
            }
            if ((entrance = DungeonData.get((Level)dim).getRoomAtPos(cpos)) != null && entrance.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
                player.getAdvancements().award(dim.getServer().getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"dungeons/enter_advanced_dungeon")), "advanced_dungeon");
                if (multiplayerHardcore != null) {
                    for (ServerPlayer friend : multiplayerHardcore) {
                        friend.getAdvancements().award(dim.getServer().getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"dungeons/enter_advanced_dungeon")), "advanced_dungeon");
                    }
                }
            }
        } else if (DungeonUtils.isDimensionPersonalBuild((Level)dim) && !DungeonUtils.isPersonalBuildChunk(new BlockPos((int)x, (int)y, (int)z))) {
            x += 1.0;
            z += 0.5;
            if (DungeonUtils.isDimensionPersonalBuild(player.level()) && DungeonUtils.isDimensionPersonalBuild((Level)dim)) {
                // empty if block
            }
        } else {
            x += 0.5;
            z += 0.5;
        }
        DimensionTransition dt = new DimensionTransition(dim, new Vec3(x, y, z), new Vec3(0.0, 0.0, 0.0), destYaw, destPitch, false, DimensionTransition.DO_NOTHING);
        player.changeDimension(dt);
        if (multiplayerHardcore != null) {
            for (ServerPlayer friend : multiplayerHardcore) {
                friend.changeDimension(dt);
            }
        }
        return player;
    }

    protected void sendPlayerBackHome(ServerPlayer player) {
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastZ = 0.0f;
        float lastYaw = player.getRotationVector().y;
        Optional respawn = player.getSleepingPos();
        if (respawn.isPresent()) {
            lastX = ((BlockPos)respawn.get()).getX();
            lastY = ((BlockPos)respawn.get()).getY() + 3;
            lastZ = ((BlockPos)respawn.get()).getZ();
        } else {
            lastX = player.getServer().getLevel(Level.OVERWORLD).getLevelData().getSpawnPos().getX();
            lastY = player.getServer().getLevel(Level.OVERWORLD).getLevelData().getSpawnPos().getY() + 2;
            lastZ = player.getServer().getLevel(Level.OVERWORLD).getLevelData().getSpawnPos().getZ();
        }
        this.actuallyPerformTeleport(player, player.getServer().getLevel(Level.OVERWORLD), lastX, lastY, lastZ, lastYaw);
    }

    public boolean checkPortalIntegrity(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)worldIn) && !DungeonUtils.isPersonalBuildChunk(pos)) {
            return true;
        }
        return DungeonUtils.isDimensionDungeon((Level)worldIn) || this.isPortalShapeIntact(state, worldIn, pos);
    }

    private boolean isPortalShapeIntact(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        TileEntityPortalKeyhole te = this.findKeyholeForThisPortal(state, worldIn, pos);
        if (te == null) {
            return false;
        }
        if (!te.isActivated()) {
            return false;
        }
        BlockState keyholeBlock = worldIn.getBlockState(te.getBlockPos());
        boolean frameLevel1 = this.checkPortalFrameLevel1(worldIn, te.getBlockPos());
        if (!frameLevel1) {
            return false;
        }
        ItemStack key = te.getObjectInserted();
        int keyLevel = ((BaseItemKey)key.getItem()).getKeyLevel(key);
        if (key.getItem() instanceof ItemPortalKey && keyLevel >= 2) {
            boolean frameLevel2 = false;
            frameLevel2 = keyholeBlock.getValue((Property)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeBlock.getValue((Property)BlockPortalKeyhole.FACING) == Direction.EAST ? this.checkPortalFrameLevel2NorthSouth(worldIn, te.getBlockPos()) : this.checkPortalFrameLevel2WestEast(worldIn, te.getBlockPos());
            if (!frameLevel2) {
                return false;
            }
        }
        return true;
    }

    private TileEntityPortalKeyhole findKeyholeForThisPortal(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        BlockPos p = pos.above();
        for (int i = 0; i < 2; ++i) {
            BlockState keyhole = worldIn.getBlockState(p);
            if (keyhole.getBlock() == BlockRegistrar.BLOCK_PORTAL_KEYHOLE.get()) {
                return (TileEntityPortalKeyhole)worldIn.getBlockEntity(p);
            }
            p = p.above();
        }
        return null;
    }

    public static boolean isValidPortalFrameBlock(Block b) {
        return b.builtInRegistryHolder().is(tag_portal_frame_blocks);
    }

    private boolean checkPortalFrameLevel1(LevelAccessor worldIn, BlockPos keyhole) {
        BlockState keyholeState = worldIn.getBlockState(keyhole);
        ArrayList<BlockState> blocks = keyholeState.getValue((Property)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeState.getValue((Property)BlockPortalKeyhole.FACING) == Direction.EAST ? BlockGoldPortal.getPortalFrameMaterialsNorthSouth(worldIn, keyhole) : BlockGoldPortal.getPortalFrameMaterialsWestEast(worldIn, keyhole);
        for (int i = 0; i < 9; ++i) {
            if (BlockGoldPortal.isValidPortalFrameBlock(blocks.get(i).getBlock())) continue;
            return false;
        }
        return blocks.get(9).getBlock() == BlockRegistrar.BLOCK_GILDED_PORTAL.get() && blocks.get(10).getBlock() == BlockRegistrar.BLOCK_GILDED_PORTAL.get();
    }

    public static ArrayList<BlockState> getPortalFrameMaterialsWestEast(LevelAccessor worldIn, BlockPos keyhole) {
        ArrayList<BlockState> retval = new ArrayList<BlockState>();
        retval.add(worldIn.getBlockState(keyhole.west().below()));
        retval.add(worldIn.getBlockState(keyhole.west().below(2)));
        retval.add(worldIn.getBlockState(keyhole.east().below()));
        retval.add(worldIn.getBlockState(keyhole.east().below(2)));
        retval.add(worldIn.getBlockState(keyhole.below(3)));
        retval.add(worldIn.getBlockState(keyhole.west(3).below(2)));
        retval.add(worldIn.getBlockState(keyhole.west(3).below(3)));
        retval.add(worldIn.getBlockState(keyhole.east(3).below(2)));
        retval.add(worldIn.getBlockState(keyhole.east(3).below(3)));
        retval.add(worldIn.getBlockState(keyhole.west(3).below(1)));
        retval.add(worldIn.getBlockState(keyhole.east(3).below(1)));
        retval.add(worldIn.getBlockState(keyhole.west(1)));
        retval.add(worldIn.getBlockState(keyhole.east(1)));
        retval.add(worldIn.getBlockState(keyhole.west(3).below(1).north(1)));
        retval.add(worldIn.getBlockState(keyhole.west(3).below(1).south(1)));
        retval.add(worldIn.getBlockState(keyhole.east(3).below(1).north(1)));
        retval.add(worldIn.getBlockState(keyhole.east(3).below(1).south(1)));
        return retval;
    }

    public static ArrayList<BlockState> getPortalFrameMaterialsNorthSouth(LevelAccessor worldIn, BlockPos keyhole) {
        ArrayList<BlockState> retval = new ArrayList<BlockState>();
        retval.add(worldIn.getBlockState(keyhole.north().below()));
        retval.add(worldIn.getBlockState(keyhole.north().below(2)));
        retval.add(worldIn.getBlockState(keyhole.south().below()));
        retval.add(worldIn.getBlockState(keyhole.south().below(2)));
        retval.add(worldIn.getBlockState(keyhole.below(3)));
        retval.add(worldIn.getBlockState(keyhole.north(3).below(2)));
        retval.add(worldIn.getBlockState(keyhole.north(3).below(3)));
        retval.add(worldIn.getBlockState(keyhole.south(3).below(2)));
        retval.add(worldIn.getBlockState(keyhole.south(3).below(3)));
        retval.add(worldIn.getBlockState(keyhole.north(3).below(1)));
        retval.add(worldIn.getBlockState(keyhole.south(3).below(1)));
        retval.add(worldIn.getBlockState(keyhole.north(1)));
        retval.add(worldIn.getBlockState(keyhole.south(1)));
        retval.add(worldIn.getBlockState(keyhole.north(3).below(1).east(1)));
        retval.add(worldIn.getBlockState(keyhole.north(3).below(1).west(1)));
        retval.add(worldIn.getBlockState(keyhole.south(3).below(1).east(1)));
        retval.add(worldIn.getBlockState(keyhole.south(3).below(1).west(1)));
        return retval;
    }

    private boolean checkPortalFrameLevel2WestEast(LevelAccessor worldIn, BlockPos keyhole) {
        if (worldIn.getBlockState(keyhole.west(1)).getBlock() != BlockRegistrar.BLOCK_PORTAL_CROWN.get() || worldIn.getBlockState(keyhole.east(1)).getBlock() != BlockRegistrar.BLOCK_PORTAL_CROWN.get()) {
            return false;
        }
        int front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.west(3).below(1).north(1));
        int back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.west(3).below(1).south(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.east(3).below(1).north(1));
        back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.east(3).below(1).south(1));
        return front >= 2 || back >= 2;
    }

    private boolean checkPortalFrameLevel2NorthSouth(LevelAccessor worldIn, BlockPos keyhole) {
        if (worldIn.getBlockState(keyhole.north(1)).getBlock() != BlockRegistrar.BLOCK_PORTAL_CROWN.get() || worldIn.getBlockState(keyhole.south(1)).getBlock() != BlockRegistrar.BLOCK_PORTAL_CROWN.get()) {
            return false;
        }
        int front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.north(3).below(1).west(1));
        int back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.north(3).below(1).east(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.south(3).below(1).west(1));
        back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.south(3).below(1).east(1));
        return front >= 2 || back >= 2;
    }

    public static int getBannerLevel(LevelAccessor worldIn, BlockPos pos) {
        Block banner = worldIn.getBlockState(pos).getBlock();
        if (banner != Blocks.WHITE_WALL_BANNER && banner != Blocks.PURPLE_WALL_BANNER) {
            return 0;
        }
        return 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (DungeonConfig.showParticles) {
            double d0 = (float)pos.getX() + rand.nextFloat();
            double d1 = (float)pos.getY() + 0.8f;
            double d2 = (float)pos.getZ() + rand.nextFloat();
            double xspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
            double zspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
            worldIn.addParticle((ParticleOptions)ParticleTypes.END_ROD, d0, d1, d2, xspeed, 0.0, zspeed);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityGoldPortal(pos, state);
    }

    public Predicate<Entity> getSelector() {
        return entity -> entity instanceof ServerPlayer;
    }
}

