/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.network.chat.Component;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.config.ConfigMigrator;
import org.embeddedt.embeddium.impl.gui.options.TextProvider;

public class EmbeddiumOptions {
    private static final String DEFAULT_FILE_NAME = "embeddium-options.json";
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final PerformanceSettings performance = new PerformanceSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    private boolean readOnly;
    private Path configPath;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public static EmbeddiumOptions defaults() {
        EmbeddiumOptions options = new EmbeddiumOptions();
        options.configPath = EmbeddiumOptions.getConfigPath(DEFAULT_FILE_NAME);
        return options;
    }

    public static EmbeddiumOptions load() {
        return EmbeddiumOptions.load(DEFAULT_FILE_NAME);
    }

    public static EmbeddiumOptions load(String name) {
        EmbeddiumOptions config;
        Path path = EmbeddiumOptions.getConfigPath(name);
        boolean resaveConfig = true;
        if (Files.exists(path, new LinkOption[0])) {
            try (FileReader reader = new FileReader(path.toFile());){
                config = (EmbeddiumOptions)GSON.fromJson((Reader)reader, EmbeddiumOptions.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse config", e);
            }
            catch (JsonSyntaxException e) {
                Embeddium.logger().error("Could not parse config, will fallback to default settings", (Throwable)e);
                config = new EmbeddiumOptions();
                resaveConfig = false;
            }
        } else {
            config = new EmbeddiumOptions();
        }
        config.configPath = path;
        try {
            if (resaveConfig) {
                EmbeddiumOptions.writeToDisk(config);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    private static Path getConfigPath(String name) {
        return ConfigMigrator.handleConfigMigration(name);
    }

    public static void writeToDisk(EmbeddiumOptions config) throws IOException {
        if (config.isReadOnly()) {
            throw new IllegalStateException("Config file is read-only");
        }
        Path dir = config.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(dir));
        }
        Path tempPath = config.configPath.resolveSibling(String.valueOf(config.configPath.getFileName()) + ".tmp");
        Files.writeString(tempPath, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
        Files.move(tempPath, config.configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String getFileName() {
        return this.configPath.getFileName().toString();
    }

    public static class QualitySettings {
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality leavesQuality = GraphicsQuality.DEFAULT;
        public boolean enableVignette = true;
        public boolean useQuadNormalsForShading = false;
    }

    public static class AdvancedSettings {
        public boolean enableMemoryTracing = false;
        public boolean useAdvancedStagingBuffers = true;
        public boolean disableIncompatibleModWarnings = false;
        public int cpuRenderAheadLimit = 3;
    }

    public static class PerformanceSettings {
        public int chunkBuilderThreads = 0;
        @SerializedName(value="always_defer_chunk_updates_v2")
        public boolean alwaysDeferChunkUpdates = true;
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useBlockFaceCulling = true;
        public boolean useCompactVertexFormat = true;
        @SerializedName(value="use_translucent_face_sorting_v2")
        public boolean useTranslucentFaceSorting = true;
        public boolean useRenderPassOptimization = true;
        public boolean useNoErrorGLContext = true;
    }

    public static class NotificationSettings {
        public boolean hasClearedDonationButton = false;
        public boolean hasSeenDonationPrompt = false;
    }

    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT("options.gamma.default"),
        FANCY("options.clouds.fancy"),
        FAST("options.clouds.fast");

        private final Component name;

        private GraphicsQuality(String name) {
            this.name = Component.translatable((String)name);
        }

        @Override
        public Component getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(GraphicsStatus graphicsMode) {
            return this == FANCY || this == DEFAULT && (graphicsMode == GraphicsStatus.FANCY || graphicsMode == GraphicsStatus.FABULOUS);
        }
    }
}

