/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.core;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.compatibility.checks.ResourcePackScanner;
import org.embeddedt.embeddium.impl.gui.screen.ConfigCorruptedScreen;
import org.lwjgl.opengl.GL32C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Shadow
    @Final
    private ReloadableResourceManager resourceManager;
    @Unique
    private final LongArrayFIFOQueue fences = new LongArrayFIFOQueue(8);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(GameConfig args, CallbackInfo ci) {
        if (Embeddium.options().isReadOnly()) {
            Screen parent = Minecraft.getInstance().screen;
            Minecraft.getInstance().setScreen((Screen)new ConfigCorruptedScreen(() -> parent));
        }
    }

    @Inject(method={"runTick"}, at={@At(value="HEAD")})
    private void preRender(boolean tick, CallbackInfo ci) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        profiler.push("wait_for_gpu");
        block0: while (this.fences.size() > Embeddium.options().advanced.cpuRenderAheadLimit) {
            int status;
            long fence = this.fences.dequeueLong();
            for (int i = 0; i < 40; ++i) {
                int status2 = GL32C.glClientWaitSync((long)fence, (int)1, (long)1000L);
                if (status2 == 37146 || status2 == 37148) {
                    GL32C.glDeleteSync((long)fence);
                    continue block0;
                }
                if (status2 != 37149) continue;
                throw new RuntimeException("Failed to wait on fence object");
            }
            do {
                Thread.yield();
                status = GL32C.glClientWaitSync((long)fence, (int)1, (long)10000L);
                if (status != 37146 && status != 37148) continue;
                GL32C.glDeleteSync((long)fence);
                continue block0;
            } while (status != 37149);
            throw new RuntimeException("Failed to wait on fence object");
        }
        profiler.pop();
    }

    @Inject(method={"runTick"}, at={@At(value="RETURN")})
    private void postRender(boolean tick, CallbackInfo ci) {
        long fence = GL32C.glFenceSync((int)37143, (int)0);
        if (fence == 0L) {
            throw new RuntimeException("Failed to create fence object");
        }
        this.fences.enqueue(fence);
    }

    @Inject(method={"buildInitialScreens"}, at={@At(value="TAIL")})
    private void postInit(CallbackInfoReturnable<Runnable> cir) {
        ResourcePackScanner.checkIfCoreShaderLoaded((ResourceManager)this.resourceManager);
    }

    @Inject(method={"reloadResourcePacks()Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="TAIL")})
    private void postResourceReload(CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ResourcePackScanner.checkIfCoreShaderLoaded((ResourceManager)this.resourceManager);
    }
}

