/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.render.world;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.WritableLevelData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ClientLevel.class}, priority=500)
public abstract class ClientLevelMixin
extends Level {
    private BlockPos.MutableBlockPos embeddium$particlePos;
    private final Consumer<AmbientParticleSettings> embeddium$particleSettingsConsumer = settings -> this.lambda$doAnimateTick$8(this.embeddium$particlePos, (AmbientParticleSettings)settings);

    protected ClientLevelMixin(WritableLevelData p_270739_, ResourceKey<Level> p_270683_, RegistryAccess p_270200_, Holder<DimensionType> p_270240_, Supplier<ProfilerFiller> p_270692_, boolean p_270904_, boolean p_270470_, long p_270248_, int p_270466_) {
        super(p_270739_, p_270683_, p_270200_, p_270240_, p_270692_, p_270904_, p_270470_, p_270248_, p_270466_);
    }

    @Shadow
    private void lambda$doAnimateTick$8(BlockPos.MutableBlockPos pos, AmbientParticleSettings settings) {
        throw new AssertionError();
    }

    @Shadow
    protected abstract void trySpawnDripParticles(BlockPos var1, BlockState var2, ParticleOptions var3, boolean var4);

    @Redirect(method={"animateTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;create()Lnet/minecraft/util/RandomSource;"))
    private RandomSource createLocal() {
        return new SingleThreadedRandomSource(RandomSupport.generateUniqueSeed());
    }

    @Overwrite
    public void doAnimateTick(int xCenter, int yCenter, int zCenter, int radius, RandomSource random, @Nullable Block markerBlock, BlockPos.MutableBlockPos pos) {
        int x = xCenter + (random.nextInt(radius) - random.nextInt(radius));
        int y = yCenter + (random.nextInt(radius) - random.nextInt(radius));
        int z = zCenter + (random.nextInt(radius) - random.nextInt(radius));
        pos.set(x, y, z);
        BlockState blockState = this.getBlockState((BlockPos)pos);
        blockState.getBlock().animateTick(blockState, (Level)this, (BlockPos)pos, random);
        FluidState fluidState = blockState.getFluidState();
        if (!fluidState.isEmpty()) {
            fluidState.animateTick((Level)this, (BlockPos)pos, random);
            ParticleOptions particleoptions = fluidState.getDripParticle();
            if (particleoptions != null && random.nextInt(10) == 0) {
                boolean flag = blockState.isFaceSturdy((BlockGetter)this, (BlockPos)pos, Direction.DOWN);
                BlockPos blockpos = pos.below();
                this.trySpawnDripParticles(blockpos, this.getBlockState(blockpos), particleoptions, flag);
            }
        }
        if (blockState.getBlock() == markerBlock) {
            this.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, blockState), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
        }
        if (!blockState.isCollisionShapeFullBlock((BlockGetter)this, (BlockPos)pos)) {
            this.embeddium$particlePos = pos;
            ((Biome)this.getBiome((BlockPos)pos).value()).getAmbientParticle().ifPresent(this.embeddium$particleSettingsConsumer);
        }
    }
}

