/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.misc;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.liopyu.entityjs.builders.misc.CustomLivingEntityTypeBuilderJS;
import net.liopyu.entityjs.client.living.model.CustomGeoLayerJSBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.animation.keyframe.event.KeyFrameEvent;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.KeyFrameData;
import software.bernie.geckolib.animation.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public abstract class CustomEntityJSBuilder
extends BuilderBase<EntityType<?>> {
    public transient float width;
    public transient float height;
    public transient int clientTrackingRange;
    public transient int updateInterval;
    public transient MobCategory mobCategory;
    public transient Function<LivingEntity, Object> modelResource;
    public transient Function<LivingEntity, Object> textureResource;
    public transient Function<LivingEntity, Object> animationResource;
    public transient RenderType renderType;
    public final transient List<AnimationControllerSupplier<?>> animationSuppliers;
    public static final List<CustomEntityJSBuilder> thisList = new ArrayList<CustomEntityJSBuilder>();
    public transient Consumer<ContextUtils.RenderContextCustom<?>> render;
    public transient boolean summonable;
    public transient boolean save;
    public transient boolean fireImmune;
    public transient ResourceLocation[] immuneTo;
    public transient boolean spawnFarFromPlayer;
    public transient float scaleHeight;
    public transient float scaleWidth;
    public transient Consumer<ContextUtils.ScaleModelRenderContext> scaleModelForRender;
    public final List<CustomGeoLayerJSBuilder<? extends LivingEntity>> layerList = new ArrayList<CustomGeoLayerJSBuilder<? extends LivingEntity>>();
    public final List<CustomGeoLayerJSBuilder<? extends LivingEntity>> glowingLayerList = new ArrayList<CustomGeoLayerJSBuilder<? extends LivingEntity>>();
    public transient Boolean defaultDeathPose;
    public transient Function<LivingEntity, net.minecraft.client.renderer.RenderType> renderTypeFunction;

    public CustomEntityJSBuilder(ResourceLocation i) {
        super(i);
        thisList.add(this);
        this.translationKey("entity." + i.getNamespace() + "." + i.getPath());
        this.width = 1.0f;
        this.height = 1.0f;
        this.summonable = true;
        this.save = true;
        this.immuneTo = new ResourceLocation[0];
        this.fireImmune = false;
        this.spawnFarFromPlayer = false;
        this.clientTrackingRange = 5;
        this.updateInterval = 1;
        this.mobCategory = MobCategory.MISC;
        this.renderType = RenderType.CUTOUT;
        this.animationSuppliers = new ArrayList();
        this.modelResource = t -> this.newID("geo/entity/", ".geo.json");
        this.textureResource = t -> this.newID("textures/entity/", ".png");
        this.animationResource = t -> this.newID("animations/entity/", ".animation.json");
        this.scaleHeight = 1.0f;
        this.scaleWidth = 1.0f;
        this.defaultDeathPose = true;
    }

    @Info(value="Sets a function to determine the model resource for the entity.\nThe provided Function accepts a parameter of type T (the entity),\nallowing changing the model based on information about the entity.\nThe default behavior returns <namespace>:geo/entity/<path>.geo.json.\n\nExample usage:\n```javascript\nentityBuilder.modelResource(entity => {\n    // Define logic to determine the model resource for the entity\n    // Use information about the entity provided by the context.\n    return \"kubejs:geo/entity/wyrm.geo.json\" // Some ResourceLocation representing the model resource;\n});\n```\n")
    public CustomEntityJSBuilder modelResource(Function<LivingEntity, Object> function) {
        this.modelResource = entity -> {
            Object obj = function.apply((LivingEntity)entity);
            if (obj instanceof String && !obj.toString().equals("undefined")) {
                return ResourceLocation.parse((String)((String)obj));
            }
            if (obj instanceof ResourceLocation) {
                return (ResourceLocation)obj;
            }
            EntityJSHelperClass.logWarningMessageOnce("Invalid model resource: " + String.valueOf(obj) + ". Defaulting to " + String.valueOf(this.newID("geo/entity/", ".geo.json")));
            return this.newID("geo/entity/", ".geo.json");
        };
        return this;
    }

    @Info(value="Sets a function to determine the texture resource for the entity.\nThe provided Function accepts a parameter of type T (the entity),\nallowing changing the texture based on information about the entity.\nThe default behavior returns <namespace>:textures/entity/<path>.png.\n\nExample usage:\n```javascript\nentityBuilder.textureResource(entity => {\n    // Define logic to determine the texture resource for the entity\n    // Use information about the entity provided by the context.\n    return \"kubejs:textures/entity/wyrm.png\" // Some ResourceLocation representing the texture resource;\n});\n```\n")
    public CustomEntityJSBuilder textureResource(Function<LivingEntity, Object> function) {
        this.textureResource = entity -> {
            Object obj = function.apply((LivingEntity)entity);
            if (obj instanceof String && !obj.toString().equals("undefined")) {
                return ResourceLocation.parse((String)((String)obj));
            }
            if (obj instanceof ResourceLocation) {
                return (ResourceLocation)obj;
            }
            EntityJSHelperClass.logWarningMessageOnce("Invalid texture resource: " + String.valueOf(obj) + ". Defaulting to " + String.valueOf(this.newID("textures/entity/", ".png")));
            return this.newID("textures/entity/", ".png");
        };
        return this;
    }

    @Info(value="Sets a function to determine the animation resource for the entity.\nThe provided Function accepts a parameter of type T (the entity),\nallowing changing the animations based on information about the entity.\nThe default behavior returns <namespace>:animations/<path>.animation.json.\n\nExample usage:\n```javascript\nentityBuilder.animationResource(entity => {\n    // Define logic to determine the animation resource for the entity\n    // Use information about the entity provided by the context.\n    //return some ResourceLocation representing the animation resource;\n    return \"kubejs:animations/entity/wyrm.animation.json\" // Some ResourceLocation representing the animation resource;\n});\n```\n")
    public CustomEntityJSBuilder animationResource(Function<LivingEntity, Object> function) {
        this.animationResource = entity -> {
            Object obj = function.apply((LivingEntity)entity);
            if (obj instanceof String && !obj.toString().equals("undefined")) {
                return ResourceLocation.parse((String)((String)obj));
            }
            if (obj instanceof ResourceLocation) {
                return (ResourceLocation)obj;
            }
            EntityJSHelperClass.logWarningMessageOnce("Invalid animation resource: " + String.valueOf(obj) + ". Defaulting to " + String.valueOf(this.newID("animations/entity/", ".animation.json")));
            return this.newID("animations/entity/", ".animation.json");
        };
        return this;
    }

    @Info(value="Boolean determining if the entity will turn sideways on death.\nDefaults to true.\nExample usage:\n```javascript\nentityBuilder.defaultDeathPose(false);\n```\n")
    public CustomEntityJSBuilder defaultDeathPose(boolean defaultDeathPose) {
        this.defaultDeathPose = defaultDeathPose;
        return this;
    }

    @Info(value="Adds an extra render layer to the mob.\n@param newGeoLayer The builder Consumer for the new render layer.\n\n    Example usage:\n    ```javascript\n    entityBuilder.newGeoLayer(builder => {\n        builder.textureResource(entity => {\n            return \"kubejs:textures/entity/sasuke.png\"\n        })\n    });\n    ```\n")
    public CustomEntityJSBuilder newGeoLayer(Consumer<CustomGeoLayerJSBuilder<? extends LivingEntity>> builderConsumer) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            CustomGeoLayerJSBuilder layerBuild = new CustomGeoLayerJSBuilder(this);
            builderConsumer.accept(layerBuild);
            this.layerList.add(layerBuild);
        }
        return this;
    }

    @Info(value="Adds an extra glowing render layer to the mob.\n@param newGlowingGeoLayer The builder Consumer for the new render layer.\n\n    Example usage:\n    ```javascript\n    entityBuilder.newGlowingGeoLayer(builder => {\n        builder.textureResource(entity => {\n            return \"kubejs:textures/entity/sasuke.png\"\n        })\n    });\n    ```\n")
    public CustomEntityJSBuilder newGlowingGeoLayer(Consumer<CustomGeoLayerJSBuilder<? extends LivingEntity>> builderConsumer) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            CustomGeoLayerJSBuilder layerBuild = new CustomGeoLayerJSBuilder(this);
            builderConsumer.accept(layerBuild);
            this.glowingLayerList.add(layerBuild);
        }
        return this;
    }

    @Info(value="Sets the scale of the model.\n\nExample usage:\n```javascript\nentityBuilder.modelSize(2,2);\n```\n")
    public CustomEntityJSBuilder modelSize(float scaleHeight, float scaleWidth) {
        this.scaleHeight = scaleHeight;
        this.scaleWidth = scaleWidth;
        return this;
    }

    @Info(value="@param scaleModelForRender A Consumer to determing logic for model scaling and rendering\n    without affecting core logic such as hitbox sizing.\n\nExample usage:\n```javascript\nentityBuilder.scaleModelForRender(context => {\n    const { entity, widthScale, heightScale, poseStack, model, isReRender, partialTick, packedLight, packedOverlay } = context\n    poseStack.scale(0.5, 0.5, 0.5)\n});\n```\n")
    public CustomEntityJSBuilder scaleModelForRender(Consumer<ContextUtils.ScaleModelRenderContext> scaleModelForRender) {
        this.scaleModelForRender = scaleModelForRender;
        return this;
    }

    @Info(value="Sets the list of block names to which the entity is immune.\n\nExample usage:\n```javascript\nentityBuilder.immuneTo(\"minecraft:stone\", \"minecraft:dirt\");\n```\n")
    public CustomEntityJSBuilder immuneTo(String ... blockNames) {
        this.immuneTo = (ResourceLocation[])Arrays.stream(blockNames).map(ResourceLocation::parse).toArray(ResourceLocation[]::new);
        return this;
    }

    @Info(value="Sets whether the entity can spawn far from the player.\n\nExample usage:\n```javascript\nentityBuilder.canSpawnFarFromPlayer(true);\n```\n")
    public CustomEntityJSBuilder canSpawnFarFromPlayer(boolean canSpawnFar) {
        this.spawnFarFromPlayer = canSpawnFar;
        return this;
    }

    @Info(value="Defines logic to render the entity.\n\nExample usage:\n```javascript\nentityBuilder.render(context => {\n    // Define logic to render the entity\n    context.poseStack.scale(0.5, 0.5, 0.5);\n});\n```\n")
    public CustomEntityJSBuilder render(Consumer<ContextUtils.RenderContextCustom<?>> render) {
        this.render = render;
        return this;
    }

    @HideFromJS
    public static MobCategory stringToMobCategory(String category) {
        return switch (category) {
            case "monster" -> MobCategory.MONSTER;
            case "creature" -> MobCategory.CREATURE;
            case "ambient" -> MobCategory.AMBIENT;
            case "water_creature" -> MobCategory.WATER_CREATURE;
            case "misc" -> MobCategory.MISC;
            default -> MobCategory.MISC;
        };
    }

    @Info(value="Sets whether the entity is summonable.\n\nExample usage:\n```javascript\nentityBuilder.setSummonable(true);\n```\n")
    public CustomEntityJSBuilder setSummonable(boolean b) {
        this.summonable = b;
        return this;
    }

    @Info(value="Sets the mob category for the entity.\nAvailable options: 'monster', 'creature', 'ambient', 'water_creature', 'misc'.\nDefaults to 'misc'.\n\nExample usage:\n```javascript\nentityBuilder.mobCategory('monster');\n```\n")
    public CustomEntityJSBuilder mobCategory(String category) {
        this.mobCategory = CustomEntityJSBuilder.stringToMobCategory(category);
        return this;
    }

    @Info(value="Determines if the entity should serialize its data. Defaults to true.\n\nExample usage:\n```javascript\nentityBuilder.saves(false);\n```\n")
    public CustomEntityJSBuilder saves(boolean shouldSave) {
        this.save = shouldSave;
        return this;
    }

    @Info(value="Sets whether the entity is immune to fire damage.\n\nExample usage:\n```javascript\nentityBuilder.fireImmune(true);\n```\n")
    public CustomEntityJSBuilder fireImmune(boolean isFireImmune) {
        this.fireImmune = isFireImmune;
        return this;
    }

    @Info(value="Sets the hit box of the entity type.\n\n@param width The width of the entity. Defaults to 0.5.\n@param height The height of the entity. Defaults to 0.5.\n\nExample usage:\n```javascript\nentityBuilder.sized(1.0f, 1.5f);\n```\n")
    public CustomEntityJSBuilder sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Info(value="Sets the client tracking range. Defaults to 5.\n\n@param trackingRange The client tracking range.\n\nExample usage:\n```javascript\nentityBuilder.clientTrackingRange(8);\n```\n")
    public CustomEntityJSBuilder clientTrackingRange(int trackingRange) {
        this.clientTrackingRange = trackingRange;
        return this;
    }

    @Info(value="Sets the update interval in ticks of the entity.\nDefaults to 1 tick.\n\n@param updateInterval The update interval in ticks.\n\nExample usage:\n```javascript\nentityBuilder.updateInterval(5);\n```\n")
    public CustomEntityJSBuilder updateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
        return this;
    }

    @Info(value="Adds an animation controller to the entity with the specified parameters.\n\n@param name The name of the animation controller.\n@param translationTicksLength The length of translation ticks for the animation.\n@param predicate The animation predicate defining the conditions for the animation to be played.\n\nExample usage:\n```javascript\nentityBuilder.addAnimationController('exampleController', 5, event => {\n    // Define conditions for the animation to be played based on the entity.\n    if (event.entity.hurtTime > 0) {\n        event.thenLoop('spawn');\n    } else {\n        event.thenPlayAndHold('idle');\n    }\n    return true; // Some boolean condition indicating if the animation should be played;\n});\n```\n")
    public CustomEntityJSBuilder addAnimationController(String name, int translationTicksLength, IAnimationPredicateJS<?> predicate) {
        return this.addKeyAnimationController(name, translationTicksLength, predicate, null, null, null);
    }

    @Info(value="Adds a new AnimationController to the entity, with the ability to add event listeners", params={@Param(name="name", value="The name of the controller"), @Param(name="translationTicksLength", value="How many ticks it takes to transition between different animations"), @Param(name="predicate", value="The predicate for the controller, determines if an animation should continue or not"), @Param(name="soundListener", value="A sound listener, used to execute actions when the json requests a sound to play. May be null"), @Param(name="particleListener", value="A particle listener, used to execute actions when the json requests a particle. May be null"), @Param(name="instructionListener", value="A custom instruction listener, used to execute actions based on arbitrary instructions provided by the json. May be null")})
    public CustomEntityJSBuilder addKeyAnimationController(String name, int translationTicksLength, IAnimationPredicateJS predicate, @Nullable ISoundListenerJS soundListener, @Nullable IParticleListenerJS particleListener, @Nullable ICustomInstructionListenerJS instructionListener) {
        this.animationSuppliers.add(new AnimationControllerSupplier(name, translationTicksLength, predicate, null, null, null, soundListener, particleListener, instructionListener));
        return this;
    }

    @Info(value="Sets the render type for the entity via a function.\n\nExample usage:\n```javascript\nentityBuilder.renderType(entity => RenderType.entityCutoutNoCull(\"kubejs:path/to/texture\", outlineEntityBoolean));\n```\n")
    public CustomEntityJSBuilder renderType(Function<LivingEntity, net.minecraft.client.renderer.RenderType> type) {
        this.renderTypeFunction = type;
        return this;
    }

    @Info(value="Sets the render type for the entity.\n\n@param type The render type to be set. Acceptable values are:\n             - \"solid\n             - \"cutout\"\n             - \"translucent\"\n             - RenderType.SOLID\n             - RenderType.CUTOUT\n             - RenderType.TRANSLUCENT\n\nExample usage:\n```javascript\nentityBuilder.setRenderType(\"translucent\");\n```\n")
    public CustomEntityJSBuilder setRenderType(Object type) {
        if (type instanceof RenderType) {
            this.renderType = (RenderType)((Object)type);
        } else if (type instanceof String) {
            String typeString = (String)type;
            switch (typeString.toLowerCase()) {
                case "solid": {
                    this.renderType = RenderType.SOLID;
                    break;
                }
                case "cutout": {
                    this.renderType = RenderType.CUTOUT;
                    break;
                }
                case "translucent": {
                    this.renderType = RenderType.TRANSLUCENT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid render type string: " + typeString);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid render type: " + String.valueOf(type));
        }
        return this;
    }

    public EntityType<?> createObject() {
        return new CustomLivingEntityTypeBuilderJS(this).get();
    }

    public abstract EntityType.EntityFactory<?> factory();

    @HideFromJS
    public abstract AttributeSupplier.Builder getAttributeBuilder();

    @Info(value="Adds a triggerable AnimationController to the entity callable off the entity's methods anywhere.", params={@Param(name="name", value="The name of the controller"), @Param(name="translationTicksLength", value="How many ticks it takes to transition between different animations"), @Param(name="triggerableAnimationID", value="The unique identifier of the triggerable animation(sets it apart from other triggerable animations)"), @Param(name="triggerableAnimationName", value="The name of the animation defined in the animations.json"), @Param(name="loopType", value="The loop type for the triggerable animation, either 'LOOP' or 'PLAY_ONCE' or 'HOLD_ON_LAST_FRAME' or 'DEFAULT'")})
    public CustomEntityJSBuilder addTriggerableAnimationController(String name, int translationTicksLength, String triggerableAnimationName, String triggerableAnimationID, String loopType) {
        this.animationSuppliers.add(new AnimationControllerSupplier(name, translationTicksLength, new IAnimationPredicateJS(this){

            public boolean test(AnimationEventJS event) {
                return true;
            }
        }, triggerableAnimationName, triggerableAnimationID, loopType, null, null, null));
        return this;
    }

    public static enum RenderType {
        SOLID,
        CUTOUT,
        TRANSLUCENT;

    }

    @FunctionalInterface
    public static interface IAnimationPredicateJS<E extends LivingEntity> {
        @Info(value="Determines if an animation should continue for a given AnimationEvent. Return true to continue the current animation", params={@Param(name="event", value="The AnimationEvent, provides values that can be used to determine if the animation should continue or not")})
        public boolean test(AnimationEventJS<E> var1);

        default public AnimationController.AnimationStateHandler<E> toGecko() {
            return event -> {
                if (event != null) {
                    AnimationEventJS animationEventJS = new AnimationEventJS(event);
                    try {
                        if (animationEventJS == null) {
                            return PlayState.STOP;
                        }
                    }
                    catch (Exception e) {
                        ConsoleJS.STARTUP.error("Exception in IAnimationPredicateJS.toGecko()", (Throwable)e);
                        return PlayState.STOP;
                    }
                    return this.test(animationEventJS) ? PlayState.CONTINUE : PlayState.STOP;
                }
                ConsoleJS.STARTUP.error((Object)"AnimationEventJS was null in IAnimationPredicateJS.toGecko()");
                return PlayState.STOP;
            };
        }
    }

    @FunctionalInterface
    public static interface ISoundListenerJS<E extends LivingEntity> {
        public void playSound(SoundKeyFrameEventJS<E> var1);
    }

    @FunctionalInterface
    public static interface IParticleListenerJS<E extends LivingEntity> {
        public void summonParticle(ParticleKeyFrameEventJS<E> var1);
    }

    @FunctionalInterface
    public static interface ICustomInstructionListenerJS<E extends LivingEntity> {
        public void executeInstruction(CustomInstructionKeyframeEventJS<E> var1);
    }

    public record AnimationControllerSupplier<E extends LivingEntity>(String name, int translationTicksLength, IAnimationPredicateJS<E> predicate, String triggerableAnimationName, String triggerableAnimationID, Object loopType, @Nullable ISoundListenerJS<E> soundListener, @Nullable IParticleListenerJS<E> particleListener, @Nullable ICustomInstructionListenerJS<E> instructionListener) {
        public AnimationController<E> get(E entity) {
            AnimationController controller = new AnimationController(entity, this.name, this.translationTicksLength, this.predicate.toGecko());
            if (this.triggerableAnimationID != null) {
                Object type = EntityJSHelperClass.convertObjectToDesired(this.loopType, "looptype");
                controller.triggerableAnim(this.triggerableAnimationID, RawAnimation.begin().then(this.triggerableAnimationName, (Animation.LoopType)type));
            }
            if (this.soundListener != null) {
                controller.setSoundKeyframeHandler(event -> this.soundListener.playSound(new SoundKeyFrameEventJS(event)));
            }
            if (this.particleListener != null) {
                controller.setParticleKeyframeHandler(event -> this.particleListener.summonParticle(new ParticleKeyFrameEventJS(event)));
            }
            if (this.instructionListener != null) {
                controller.setCustomInstructionKeyframeHandler(event -> this.instructionListener.executeInstruction(new CustomInstructionKeyframeEventJS(event)));
            }
            return controller;
        }
    }

    public static class CustomInstructionKeyframeEventJS<E extends LivingEntity>
    extends KeyFrameEventJS<E, CustomInstructionKeyframeData> {
        @Info(value="A list of all the custom instructions. In Blockbench, each line in the custom instruction box is a separate instruction.")
        public final String instructions;

        public CustomInstructionKeyframeEventJS(CustomInstructionKeyframeEvent<E> parent) {
            super(parent);
            this.instructions = parent.getKeyframeData().getInstructions();
        }
    }

    public static class ParticleKeyFrameEventJS<E extends LivingEntity>
    extends KeyFrameEventJS<E, ParticleKeyframeData> {
        @Info(value="Gets the effect id given by the Keyframe instruction from the animation.json")
        public final String effect;
        @Info(value="Gets the locator string given by the Keyframe instruction from the animation.json")
        public final String locator;
        @Info(value="Gets the script string given by the Keyframe instruction from the animation.json")
        public final String script;

        public ParticleKeyFrameEventJS(ParticleKeyframeEvent<E> parent) {
            super(parent);
            this.effect = parent.getKeyframeData().getEffect();
            this.locator = parent.getKeyframeData().getLocator();
            this.script = parent.getKeyframeData().script();
        }
    }

    public static class SoundKeyFrameEventJS<E extends LivingEntity>
    extends KeyFrameEventJS<E, SoundKeyframeData> {
        @Info(value="Gets the sound id given by the Keyframe instruction from the animation. json")
        public final String sound;

        public SoundKeyFrameEventJS(SoundKeyframeEvent<E> parent) {
            super(parent);
            this.sound = parent.getKeyframeData().getSound();
        }
    }

    public static class KeyFrameEventJS<E extends LivingEntity, B extends KeyFrameData> {
        @Info(value="The entity this animation is being applied to.")
        public final E entity;
        @Info(value="The current tick of the animation.")
        public final double animationTick;
        @Info(value="The controller handling this animation.")
        public final AnimationController<E> controller;
        @Info(value="The keyframe data containing extra information about the instruction.")
        public final B keyframeData;

        protected KeyFrameEventJS(KeyFrameEvent<E, B> parent) {
            this.animationTick = parent.getAnimationTick();
            this.entity = (LivingEntity)parent.getAnimatable();
            this.controller = parent.getController();
            this.keyframeData = parent.getKeyframeData();
        }
    }

    public static class AnimationEventJS<E extends LivingEntity> {
        private final List<RawAnimation.Stage> animationList = new ObjectArrayList();
        private final AnimationState<E> parent;

        public AnimationEventJS(AnimationState<E> parent) {
            this.parent = parent;
        }

        @Info(value="Returns the number of ticks the entity has been animating for")
        public double getAnimationTick() {
            return this.parent.getAnimationTick();
        }

        @Info(value="Returns the entity that is being animated")
        public E getEntity() {
            return (E)((LivingEntity)this.parent.getAnimatable());
        }

        public float getLimbSwing() {
            return this.parent.getLimbSwing();
        }

        public float getLimbSwingAmount() {
            return this.parent.getLimbSwingAmount();
        }

        @Info(value="Returns a number, in the range [0, 1], how far through the tick it currently is")
        public float getPartialTick() {
            return this.parent.getPartialTick();
        }

        @Info(value="If the entity is moving")
        public boolean isMoving() {
            return this.parent.isMoving();
        }

        @Info(value="Returns the animation controller this event is part of")
        public AnimationController<E> getController() {
            return this.parent.getController();
        }

        @Info(value="Sets a triggerable animation with a specified loop type callable anywhere from the entity.\n\n@param animationName The name of the animation to be triggered, this is the animation named in the json.\n@param triggerableAnimationID The unique identifier for the triggerable animation.\n@param loopTypeEnum The loop type for the triggerable animation. Accepts 'LOOP', 'PLAY_ONCE', 'HOLD_ON_LAST_FRAME', or 'DEFAULT'.\n```javascript\n event.addTriggerableAnimation('spawn', 'spawning', 'default')\n ```\n")
        public PlayState addTriggerableAnimation(String animationName, String triggerableAnimationID, Object loopTypeEnum) {
            Object type = EntityJSHelperClass.convertObjectToDesired(loopTypeEnum, "looptype");
            this.parent.getController().triggerableAnim(triggerableAnimationID, RawAnimation.begin().then(animationName, (Animation.LoopType)type));
            return PlayState.CONTINUE;
        }

        @Info(value="Sets an animation to play defaulting to the animations.json file loop type")
        public PlayState thenPlay(String animationName) {
            this.parent.getController().setAnimation(RawAnimation.begin().then(animationName, Animation.LoopType.DEFAULT));
            return PlayState.CONTINUE;
        }

        @Info(value="Sets an animation to play in a loop")
        public PlayState thenLoop(String animationName) {
            this.parent.getController().setAnimation(RawAnimation.begin().thenLoop(animationName));
            return PlayState.CONTINUE;
        }

        @Info(value="Wait a certain amount of ticks before starting the next animation")
        public PlayState thenWait(int ticks) {
            this.parent.getController().setAnimation(RawAnimation.begin().thenWait(ticks));
            return PlayState.CONTINUE;
        }

        @Info(value="Sets an animation to play and hold on the last frame")
        public PlayState thenPlayAndHold(String animationName) {
            this.parent.getController().setAnimation(RawAnimation.begin().then(animationName, Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }

        @Info(value="Sets an animation to play an x amount of times")
        public PlayState thenPlayXTimes(String animationName, int times) {
            for (int i = 0; i < times; ++i) {
                this.parent.getController().setAnimation(RawAnimation.begin().then(animationName, i == times - 1 ? Animation.LoopType.DEFAULT : Animation.LoopType.PLAY_ONCE));
            }
            return PlayState.CONTINUE;
        }

        @Info(value="Adds an animation to the current animation list")
        public AnimationEventJS<E> then(String animationName, Animation.LoopType loopType) {
            this.animationList.add(new RawAnimation.Stage(animationName, loopType));
            return this;
        }

        @Info(value="Returns any extra data that the event may have\n\nUsually used by armor animations to know what item is worn\n")
        public Map<DataTicket<?>, ?> getExtraData() {
            return this.parent.getExtraData();
        }
    }
}

