/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.worker;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.worker.StructureSearchWorker;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;

public class ConcentricRingsSearchWorker
extends StructureSearchWorker<ConcentricRingsStructurePlacement> {
    private List<ChunkPos> potentialChunks;
    private int chunkIndex = 0;
    private double minDistance = Double.MAX_VALUE;
    private Pair<BlockPos, Structure> closest;

    public ConcentricRingsSearchWorker(ServerLevel level, Player player, ItemStack stack, BlockPos startPos, ConcentricRingsStructurePlacement placement, List<Structure> structureSet, String managerId, List<Pair<UUID, ChunkPos>> foundChunks) {
        super(level, player, stack, startPos, placement, structureSet, managerId, foundChunks);
        this.potentialChunks = level.getChunkSource().getGeneratorState().getRingPositionsFor(placement);
        this.finished = !level.getServer().getWorldData().worldGenOptions().generateStructures() || this.potentialChunks == null || this.potentialChunks.isEmpty();
    }

    @Override
    public boolean hasWork() {
        return !this.finished && this.samples < (Integer)ConfigHandler.GENERAL.maxSamples.get() && this.chunkIndex < this.potentialChunks.size();
    }

    @Override
    public boolean doWork() {
        super.doWork();
        if (this.hasWork()) {
            Pair<BlockPos, Structure> pair;
            ChunkPos chunkPos = this.potentialChunks.get(this.chunkIndex);
            this.currentPos = new BlockPos(SectionPos.sectionToBlockCoord((int)chunkPos.x, (int)8), 0, SectionPos.sectionToBlockCoord((int)chunkPos.z, (int)8));
            double distance = this.startPos.distSqr((Vec3i)this.currentPos);
            if ((this.closest == null || distance < this.minDistance) && (pair = this.getStructureGeneratingAt(chunkPos)) != null) {
                this.minDistance = distance;
                this.closest = pair;
            }
            ++this.samples;
            ++this.chunkIndex;
        }
        if (this.hasWork()) {
            return true;
        }
        if (this.closest != null) {
            this.succeed((BlockPos)this.closest.getFirst(), (Structure)this.closest.getSecond());
        } else if (!this.finished) {
            this.fail();
        }
        return false;
    }

    @Override
    protected String getName() {
        return "ConcentricRingsSearchWorker";
    }

    @Override
    public boolean shouldLogRadius() {
        return false;
    }

    private Pair<BlockPos, Structure> getClosest() {
        List list = this.level.getChunkSource().getGeneratorState().getRingPositionsFor((ConcentricRingsStructurePlacement)this.placement);
        if (list == null) {
            return null;
        }
        Pair<BlockPos, Structure> closestPair = null;
        double minDistance = Double.MAX_VALUE;
        BlockPos.MutableBlockPos sampleBlockPos = new BlockPos.MutableBlockPos();
        for (ChunkPos chunkPos : list) {
            Pair<BlockPos, Structure> pair;
            sampleBlockPos.set(SectionPos.sectionToBlockCoord((int)chunkPos.x, (int)8), 32, SectionPos.sectionToBlockCoord((int)chunkPos.z, (int)8));
            double distance = sampleBlockPos.distSqr((Vec3i)this.startPos);
            if (closestPair != null && !(distance < minDistance) || (pair = this.getStructureGeneratingAt(chunkPos)) == null) continue;
            closestPair = pair;
            minDistance = distance;
        }
        return closestPair;
    }
}

