/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block.entity;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.api.FeedingTroughEvent;
import net.blay09.mods.farmingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.farmingforblockheads.network.ChickenNestEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class FeedingTroughBlockEntity
extends BalmBlockEntity
implements BalmContainerProvider {
    private static final int TICK_INTERVAL = 100;
    private final DefaultContainer container = new DefaultContainer(1){

        public void setChanged() {
            FeedingTroughBlockEntity.this.isDirty = true;
            FeedingTroughBlockEntity.this.setChanged();
        }
    };
    private int tickTimer;
    private boolean isDirty;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.feedingTrough.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FeedingTroughBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ++this.tickTimer;
        if (this.tickTimer >= 100) {
            this.teehee();
            this.tickTimer = 0;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    protected void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.container.deserialize(tagCompound.getCompound("ItemHandler"), provider);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("ItemHandler", (Tag)this.container.serialize(provider));
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
    }

    private void teehee() {
        ItemStack itemStack = this.container.getItem(0);
        if (itemStack.isEmpty() || itemStack.getCount() < 2) {
            return;
        }
        float range = FarmingForBlockheadsConfig.getActive().feedingTroughRange;
        AABB aabb = new AABB((double)((float)this.worldPosition.getX() - range), (double)((float)this.worldPosition.getY() - range), (double)((float)this.worldPosition.getZ() - range), (double)((float)this.worldPosition.getX() + range), (double)((float)this.worldPosition.getY() + range), (double)((float)this.worldPosition.getZ() + range));
        List entities = this.level.getEntitiesOfClass(Animal.class, aabb);
        if (entities.isEmpty()) {
            return;
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Animal animal : entities) {
            map.put(animal.getClass(), (Object)animal);
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.shuffle(keys);
        for (Class key : keys) {
            List list = map.get((Object)key);
            if (list.size() >= FarmingForBlockheadsConfig.getActive().feedingTroughMaxAnimals) continue;
            ArrayList<Animal> breedingCandidates = new ArrayList<Animal>();
            for (Animal animal : list) {
                if (!this.isSubmissiveAndBreedable(animal, itemStack)) continue;
                breedingCandidates.add(animal);
                if (breedingCandidates.size() < 2) continue;
                break;
            }
            if (breedingCandidates.size() != 2) continue;
            for (Animal animal : breedingCandidates) {
                this.feed(animal, itemStack);
            }
        }
    }

    private void feed(Animal animal, ItemStack itemStack) {
        FeedingTroughEvent event = new FeedingTroughEvent((BlockEntity)this, animal, itemStack);
        Balm.getEvents().fireEvent((Object)event);
        if (!event.isCanceled()) {
            animal.setInLove(null);
            ContainerUtils.extractItem((Container)this.container, (int)0, (int)1, (boolean)false);
            this.setChanged();
        }
        if (event.shouldPlayEffect()) {
            Balm.getNetworking().sendToTracking((ServerLevel)this.level, this.worldPosition, (CustomPacketPayload)new ChickenNestEffectMessage(this.worldPosition));
        }
    }

    private boolean isSubmissiveAndBreedable(Animal animal, ItemStack itemStack) {
        return animal.getAge() == 0 && animal.canFallInLove() && !animal.isBaby() && animal.isFood(itemStack);
    }

    public ItemStack getContentStack() {
        return this.container.getItem(0);
    }

    public Container getContainer() {
        return this.container;
    }
}

