/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.malkuth_slash;

import com.finderfeed.fdbosses.client.particles.malkuth_slash.MalkuthHorizontalSlashOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_slash.MalkuthSlashRenderer;
import com.finderfeed.fdlib.systems.particle.FDParticleRenderType;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.renderers.QuadRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MalkuthHorizontalSlashParticle
extends Particle {
    private MalkuthHorizontalSlashOptions options;
    public static final FDParticleRenderType ICE_RENDER_TYPE = new FDParticleRenderType(){

        public void end() {
        }

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MalkuthSlashRenderer.ICE_LOCATION);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getParticleShader);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }
    };
    public static final FDParticleRenderType FIRE_RENDER_TYPE = new FDParticleRenderType(){

        public void end() {
        }

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MalkuthSlashRenderer.FIRE_LOCATION);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getParticleShader);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }
    };

    public MalkuthHorizontalSlashParticle(MalkuthHorizontalSlashOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.options = options;
        this.lifetime = options.getLifetime();
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        float p = Mth.clamp((float)(((float)this.age + pticks) / (float)(this.lifetime - 1)), (float)0.0f, (float)1.0f);
        Vec3 thisPos = new Vec3(FDMathUtil.lerp((double)this.xo, (double)this.x, (double)pticks), FDMathUtil.lerp((double)this.yo, (double)this.y, (double)pticks), FDMathUtil.lerp((double)this.zo, (double)this.z, (double)pticks));
        Vec3 camPos = camera.getPosition();
        Vec3 actualPos = thisPos.subtract(camPos);
        QuadRenderer.start((VertexConsumer)vertex).translate((float)actualPos.x, (float)actualPos.y, (float)actualPos.z).sizeY(this.options.getSlashWidth() * 0.3461538f).sizeX(this.options.getSlashWidth()).direction(this.options.getSlashDirection().reverse()).verticalRendering().renderBack().rotationDegrees(this.options.getRotation()).color(1.0f, 1.0f, 1.0f, 0.8f - p * 0.8f).render();
    }

    public ParticleRenderType getRenderType() {
        switch (this.options.getAttackType()) {
            case ICE: {
                return ICE_RENDER_TYPE;
            }
            case FIRE: {
                return FIRE_RENDER_TYPE;
            }
        }
        return FIRE_RENDER_TYPE;
    }

    protected int getLightColor(float p_107249_) {
        return 0xF000F0;
    }

    public static class Factory
    implements ParticleProvider<MalkuthHorizontalSlashOptions> {
        @Nullable
        public Particle createParticle(MalkuthHorizontalSlashOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new MalkuthHorizontalSlashParticle(options, level, x, y, z, xd, yd, zd);
        }
    }
}

