/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss;

import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChesedFireTrailEntity
extends Entity
implements AutoSerializable {
    @SerializableField
    private float damage = 0.0f;
    @SerializableField
    private int lifetime = 0;

    public ChesedFireTrailEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        float radius = 1.0f;
        if (!this.level().isClientSide) {
            if (this.tickCount > this.lifetime) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            this.doDamage(radius, 0.25f);
        } else {
            this.spawnParticles(radius, 1);
        }
    }

    private void spawnParticles(float radius, int amountPerTick) {
        for (int i = 0; i < amountPerTick; ++i) {
            Vec3 v = new Vec3((double)(this.random.nextFloat() * radius), 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
            Vec3 ppos = this.position().add(v);
            float spm = 0.025f * this.random.nextFloat();
            Vec3 speed = new Vec3(0.0, (double)spm, 0.0);
            BallParticleOptions options = BallParticleOptions.builder().color(1 + this.random.nextInt(40), 183 + this.random.nextInt(60), 165 + this.random.nextInt(60)).size(0.1f).scalingOptions(2, 10, 10).build();
            this.level().addParticle((ParticleOptions)options, ppos.x, ppos.y, ppos.z, speed.x, speed.y, speed.z);
        }
    }

    private void doDamage(float radius, float damageBoxHeight) {
        List list = this.level().getEntitiesOfClass(LivingEntity.class, new AABB((double)(-radius), 0.0, (double)(-radius), (double)radius, (double)damageBoxHeight, (double)radius).move(this.position()), e -> !(e instanceof ChesedBossBuddy) && e.position().multiply(1.0, 0.0, 1.0).distanceTo(this.position().multiply(1.0, 0.0, 1.0)) < (double)radius);
        for (LivingEntity entity : list) {
            entity.hurt(this.level().damageSources().magic(), this.damage);
        }
    }

    public static ChesedFireTrailEntity summon(Level level, Vec3 pos, float damage, int lifetime) {
        ChesedFireTrailEntity fireTrailEntity = new ChesedFireTrailEntity(BossEntities.CHESED_FIRE_TRAIL.get(), level);
        fireTrailEntity.setPos(pos);
        fireTrailEntity.damage = damage;
        fireTrailEntity.lifetime = lifetime;
        level.addFreshEntity((Entity)fireTrailEntity);
        return fireTrailEntity;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.autoLoad(tag);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.autoSave(tag);
    }
}

