/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_boss_spawner;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerContextAssignable;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthBossSpawner
extends BossSpawnerEntity {
    public MalkuthBossSpawner(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            for (Player player : BossTargetFinder.getEntitiesInArc(Player.class, this.level(), this.position().add(0.0, -2.0, 0.0), new Vec2(0.0f, -1.0f), (float)Math.PI, 13.0f, 29.0f)) {
                if (!this.isActive()) {
                    if (player.hasEffect(BossEffects.MARK_OF_A_KNIGHT)) continue;
                    player.addEffect(new MobEffectInstance(BossEffects.MARK_OF_A_KNIGHT, -1, 0, true, false));
                    continue;
                }
                if (player.hasEffect(BossEffects.MARK_OF_A_KNIGHT)) {
                    player.removeEffect(BossEffects.MARK_OF_A_KNIGHT);
                }
                if (!player.hasEffect(BossEffects.MARK_OF_A_COWARD)) continue;
                player.removeEffect(BossEffects.MARK_OF_A_COWARD);
            }
        } else if (this.isActive()) {
            if (this.tickCount % 2 == 0) {
                Vec3 add = new Vec3(0.25 + 0.25 * (double)this.random.nextFloat(), 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat()).add(0.0, 0.75, 0.0);
                Vec3 rnd = this.position().add(add);
                double l = add.multiply(1.0, 0.0, 1.0).length() * (double)0.1f;
                l *= l;
                Vector3f color = this.random.nextBoolean() ? MalkuthEntity.getAndRandomizeColor(MalkuthAttackType.FIRE, this.random) : MalkuthEntity.getAndRandomizeColor(MalkuthAttackType.ICE, this.random);
                float vspeed = 0.025f;
                this.level().addParticle((ParticleOptions)BallParticleOptions.builder().size(0.15f).brightness(2).color(color.x, color.y, color.z).scalingOptions(10, 0, 30).build(), true, rnd.x, rnd.y, rnd.z, add.x * (double)vspeed, (double)(0.025f + this.random.nextFloat() * 0.025f) / Math.max(1.0, l), add.z * (double)vspeed);
            }
            if (this.tickCount % 10 == 0) {
                Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(MalkuthAttackType.getRandom(this.random));
                FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
                FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
                StripeParticleOptions stripeParticleOptions = StripeParticleOptions.createHorizontalCircling(fireColorStart, fireColor, new Vec3((double)0.01f, 1.0, 0.0), (float)Math.PI, 0.05f, 20, 40, 2.0f, 0.75f, 2.0f, 0.5f, this.random.nextBoolean(), false);
                this.level().addParticle((ParticleOptions)stripeParticleOptions, true, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public EntityType<? extends BossSpawnerContextAssignable> getBossEntityType() {
        return BossEntities.MALKUTH.get();
    }

    @Override
    public Vec3 getPlayerItemsDropPosition(Vec3 deathPosition) {
        if (BossTargetFinder.isPointInCylinder(deathPosition, this.position().add(0.0, -2.0, 0.0), 13.0f, 29.0f)) {
            return this.position().add(0.0, 3.0, -34.0);
        }
        return null;
    }

    @Override
    public boolean canInteractWithBlockPos(BlockPos blockPos) {
        Vec3 v = blockPos.getCenter();
        Vec3 pos = this.position();
        double yDiff = v.y - pos.y;
        double hdist = v.multiply(1.0, 0.0, 1.0).distanceTo(pos.multiply(1.0, 0.0, 1.0));
        return !(hdist < 39.0) || !(yDiff > -4.0) || !(yDiff < 211.0);
    }

    @Override
    public Component onArenaDestructionMessage() {
        return Component.translatable((String)"fdbosses.word.tried_to_break_arena").withStyle(ChatFormatting.RED);
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

