/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_fireball;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthFireball
extends FDProjectile
implements AutoSerializable {
    public static final EntityDataAccessor<MalkuthAttackType> ATTACK_TYPE = SynchedEntityData.defineId(MalkuthFireball.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    @SerializableField
    private Vec3 moveToPos = Vec3.ZERO;
    @SerializableField
    private Vec3 targetPos = Vec3.ZERO;
    @SerializableField
    private int movingToTargetTime = -1;
    @SerializableField
    private int currentMovingToTargetTime = 0;
    @SerializableField
    private Vec3 startedMovingFromPos = Vec3.ZERO;
    @SerializableField
    private int accelerationTicks = 0;
    @SerializableField
    private float damage;

    public static MalkuthFireball summon(MalkuthAttackType type, Level level, Vec3 pos, Vec3 flyToPos, Vec3 targetPos, float damage) {
        MalkuthFireball malkuthFireball = new MalkuthFireball(BossEntities.MALKUTH_FIREBALL.get(), level);
        malkuthFireball.setAttackType(type);
        malkuthFireball.setPos(pos);
        malkuthFireball.moveToPos = flyToPos;
        malkuthFireball.targetPos = targetPos;
        malkuthFireball.damage = damage;
        malkuthFireball.doMove();
        level.addFreshEntity((Entity)malkuthFireball);
        return malkuthFireball;
    }

    public MalkuthFireball(EntityType<? extends FDProjectile> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 1000) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.level().isClientSide) {
            this.particles();
        } else {
            this.doMove();
        }
    }

    private void doMove() {
        if (!this.isMovingToTarget()) {
            Vec3 target;
            float peakSpeed = 2.0f;
            float minspeed = 0.1f;
            float maxDist = 10.0f;
            Vec3 pos = this.position();
            double dist = pos.distanceTo(target = this.moveToPos);
            if (dist >= (double)minspeed) {
                Vec3 between = target.subtract(pos).normalize();
                float p = (float)Math.clamp(dist / (double)maxDist, 0.0, 1.0);
                float speedValue = FDMathUtil.lerp((float)minspeed, (float)peakSpeed, (float)p);
                Vec3 speed = between.multiply((double)speedValue, (double)speedValue, (double)speedValue);
                this.setDeltaMovement(speed);
            } else {
                this.setDeltaMovement(Vec3.ZERO);
            }
        } else {
            if (this.accelerationTicks-- >= 0) {
                if (this.movingToTargetTime == this.currentMovingToTargetTime) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                Vec3 startPos = this.startedMovingFromPos;
                Vec3 targetPos = this.targetPos;
                Vec3 between = targetPos.subtract(startPos);
                double S = between.length();
                double t = (float)this.movingToTargetTime / 2.0f;
                double v = S / (t * 1.5);
                double a = v / t;
                Vec3 current = this.getDeltaMovement();
                Vec3 next = current.add(between.normalize().multiply(a, a, a));
                this.setDeltaMovement(next);
            }
            if (this.currentMovingToTargetTime-- <= 0) {
                this.explode();
            }
        }
    }

    public void explode() {
        if (this.getAttackType().isIce()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_ICE_FIREBALL_EXPLOSION.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        } else {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_FIREBALL_EXPLOSION.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        BossUtil.malkuthFireballExplosionParticles((ServerLevel)this.level(), this.targetPos, this.getAttackType());
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(50.0f).amplitude(1.5f).inTime(0).stayTime(0).outTime(10).build(), (Vec3)this.targetPos, (double)10.0);
        List<LivingEntity> targets = BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), this.targetPos.add(0.0, -1.0, 0.0), 3.0f, 4.0f);
        for (LivingEntity target : targets) {
            target.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_HELLSHAPER_SOURCE, this.getAttackType(), 70), this.damage);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void setMoveToTarget(int moveTime) {
        this.movingToTargetTime = moveTime;
        this.currentMovingToTargetTime = moveTime;
        this.accelerationTicks = moveTime / 2;
        this.startedMovingFromPos = this.position();
    }

    public boolean isMovingToTarget() {
        return this.movingToTargetTime != -1;
    }

    private void particles() {
        Vec3 between = new Vec3(this.getX() - this.xo, this.getY() - this.yo, this.getZ() - this.zo);
        double length = between.length();
        Vec3 pos = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
        float maxrad = 0.5f;
        float g = -0.001f;
        while ((double)g < length * (double)0.8f) {
            for (int i = 0; i < 10; ++i) {
                Vector3f color = MalkuthEntity.getAndRandomizeColor(this.getAttackType(), this.random);
                Object particleOptions = this.random.nextFloat() > 0.1f ? BallParticleOptions.builder().color(color.x, color.y, color.z).scalingOptions(0, 0, 10 + this.random.nextInt(4)).brightness(1).build() : (this.getAttackType().isFire() ? ParticleTypes.FLAME : new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 0.0f, 2.0f, true));
                float rndOut = maxrad / 2.0f + this.random.nextFloat() * maxrad / 2.0f;
                Vec3 rndOffs = new Vec3((double)(this.random.nextFloat() * 2.0f - 1.0f), (double)(this.random.nextFloat() * 2.0f - 1.0f), (double)(this.random.nextFloat() * 2.0f - 1.0f)).normalize().multiply((double)rndOut, (double)rndOut, (double)rndOut);
                Vec3 distOffset = between.normalize().multiply((double)g, (double)g, (double)g);
                Vec3 ppos = pos.add(rndOffs).subtract(distOffset);
                float vspeed = length == 0.0 ? -this.random.nextFloat() * 0.1f : 0.0f;
                this.level().addParticle((ParticleOptions)particleOptions, true, ppos.x, ppos.y, ppos.z, 0.0, (double)vspeed, 0.0);
            }
            g += maxrad;
        }
    }

    public boolean isPickable() {
        return true;
    }

    public MalkuthAttackType getAttackType() {
        return (MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE));
    }

    public void setAttackType(MalkuthAttackType type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TYPE, (Object)MalkuthAttackType.ICE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("mtype", ((MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE))).name());
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("mtype")) {
            this.entityData.set(ATTACK_TYPE, (Object)MalkuthAttackType.valueOf(tag.getString("mtype")));
        }
        this.autoLoad(tag);
    }
}

