/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.init;

import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.packets.JsonConfigSyncPacket;
import com.finderfeed.fdlib.systems.config.packets.TriggerClientsideConfigReloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="fdlib", bus=EventBusSubscriber.Bus.GAME)
public class FDGameEvents {
    @SubscribeEvent
    public static void serverStartedEvent(ServerStartedEvent event) {
        FDLib.LOGGER.info("Loading FD configs...");
        for (JsonConfig config : FDRegistries.CONFIGS) {
            config.loadFromDisk();
        }
        FDLib.LOGGER.info("Loaded FD configs.");
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new JsonConfigSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new TriggerClientsideConfigReloadPacket(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

