/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.music.data;

import com.finderfeed.fdlib.systems.music.data.FDMusicPartData;
import com.finderfeed.fdlib.util.FDByteBufCodecs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class FDMusicData {
    public static final StreamCodec<RegistryFriendlyByteBuf, FDMusicData> STREAM_CODEC = StreamCodec.composite((StreamCodec)FDMusicPartData.STREAM_CODEC.apply(ByteBufCodecs.list()), v -> v.musicPartDatas, (StreamCodec)ByteBufCodecs.INT, v -> v.startFrom, (StreamCodec)ByteBufCodecs.INT, v -> v.inactiveDeleteTime, (StreamCodec)ByteBufCodecs.INT, v -> v.defaultFadeInTime, FDByteBufCodecs.UUID, v -> v.musicSourceUUID, (datas, startFrom, inactiveDeleteTime, defaultFadeInTime, sourceUUID) -> new FDMusicData((UUID)sourceUUID, (List<FDMusicPartData>)datas).startFromPart((int)startFrom).fadeInTime((int)defaultFadeInTime).inactiveDeleteTime((int)inactiveDeleteTime));
    private List<FDMusicPartData> musicPartDatas = new ArrayList<FDMusicPartData>();
    private int startFrom = 0;
    private int inactiveDeleteTime = 6000;
    private int defaultFadeInTime = 0;
    private UUID musicSourceUUID;

    public FDMusicData(UUID uuid, FDMusicPartData musicPart) {
        this.musicPartDatas.add(musicPart);
        this.musicSourceUUID = uuid;
    }

    public FDMusicData(UUID uuid, List<FDMusicPartData> musicPart) {
        this.musicPartDatas.addAll(musicPart);
        this.musicSourceUUID = uuid;
    }

    public FDMusicData fadeInTime(int fadeInTime) {
        this.defaultFadeInTime = fadeInTime;
        return this;
    }

    public FDMusicData inactiveDeleteTime(int inactiveDeleteTime) {
        this.inactiveDeleteTime = inactiveDeleteTime;
        return this;
    }

    public FDMusicData startFromPart(int partId) {
        this.startFrom = partId;
        return this;
    }

    public FDMusicData addMusicPart(FDMusicPartData data) {
        this.musicPartDatas.add(data);
        return this;
    }

    public UUID getMusicSourceUUID() {
        return this.musicSourceUUID;
    }

    public List<FDMusicPartData> getMusicPartDatas() {
        return this.musicPartDatas;
    }

    public int getStartFrom() {
        return this.startFrom;
    }

    public int getInactiveDeleteTime() {
        return this.inactiveDeleteTime;
    }

    public int getStartFadeInTime() {
        return this.defaultFadeInTime;
    }
}

