/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.music.packets;

import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.music.FDMusic;
import com.finderfeed.fdlib.systems.music.FDMusicSystem;
import com.finderfeed.fdlib.systems.music.data.FDMusicData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:enter_music_area_packet")
public class FDMusicAreaEnterPacket
extends FDPacket {
    private FDMusicData data;
    private int fadeInTime;

    public FDMusicAreaEnterPacket(FDMusicData musicData, int fadeInTime) {
        this.data = musicData;
        this.fadeInTime = fadeInTime;
    }

    public FDMusicAreaEnterPacket(RegistryFriendlyByteBuf buf) {
        this.data = (FDMusicData)FDMusicData.STREAM_CODEC.decode((Object)buf);
        this.fadeInTime = buf.readInt();
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        FDMusicData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
        buf.writeInt(this.fadeInTime);
    }

    @Override
    public void clientAction(IPayloadContext context) {
        FDMusic music = FDMusicSystem.getMusic(this.data.getMusicSourceUUID());
        if (music == null) {
            FDMusicSystem.addMusic(this.data);
        } else {
            music.fadeIn(this.fadeInTime);
        }
    }

    @Override
    public void serverAction(IPayloadContext context) {
    }
}

