/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.screen_effect;

import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public abstract class ScreenEffect<T extends ScreenEffectData> {
    private int inTime;
    private int stayTime;
    private int outTime;
    private T data;

    public ScreenEffect(T data, int inTime, int stayTime, int outTime) {
        this.inTime = inTime;
        this.stayTime = stayTime;
        this.outTime = outTime;
        this.data = data;
    }

    public abstract void render(GuiGraphics var1, DeltaTracker var2, int var3, float var4, float var5);

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public boolean isInTime(int currentTick) {
        if (this.inTime == 0) {
            return false;
        }
        return currentTick <= this.inTime;
    }

    public boolean isStayTime(int currentTick) {
        if (this.stayTime == 0) {
            return false;
        }
        int time = currentTick - this.inTime;
        if (this.inTime == 0) {
            return time > 0 && time <= this.stayTime;
        }
        return time > 0 && time <= this.stayTime;
    }

    public boolean isOutTime(int currentTick) {
        if (this.outTime == 0) {
            return false;
        }
        int time = currentTick - this.inTime - this.stayTime;
        if (this.stayTime == 0 && this.inTime == 0) {
            return time >= 0 && time <= this.outTime;
        }
        return time > 0 && time <= this.outTime;
    }

    public float getInTimePercent(int currentTick, float pticks) {
        if (this.inTime == 0) {
            return 0.0f;
        }
        float time = Mth.clamp((float)((float)currentTick + pticks), (float)0.0f, (float)this.inTime);
        return time / (float)this.inTime;
    }

    public float getStayTimePercent(int currentTick, float pticks) {
        if (this.stayTime == 0) {
            return 0.0f;
        }
        float time = Mth.clamp((float)((float)currentTick + pticks - (float)this.inTime), (float)0.0f, (float)this.stayTime);
        return time / (float)this.stayTime;
    }

    public float getOutTimePercent(int currentTick, float pticks) {
        if (this.outTime == 0) {
            return 0.0f;
        }
        float time = Mth.clamp((float)((float)currentTick + pticks - (float)this.inTime - (float)this.stayTime), (float)0.0f, (float)this.outTime);
        return time / (float)this.outTime;
    }

    public void setOutTime(int outTime) {
        this.outTime = outTime;
    }

    public void setInTime(int inTime) {
        this.inTime = inTime;
    }

    public void setStayTime(int stayTime) {
        this.stayTime = stayTime;
    }

    public int getOutTime() {
        return this.outTime;
    }

    public int getInTime() {
        return this.inTime;
    }

    public int getStayTime() {
        return this.stayTime;
    }

    public int getLifetime() {
        return this.stayTime + this.outTime + this.inTime;
    }
}

