/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.client;

import dev.ftb.mods.ftbbackups.Backups;
import dev.ftb.mods.ftbbackups.api.Backup;
import dev.ftb.mods.ftbbackups.api.IArchivalPlugin;
import dev.ftb.mods.ftbbackups.archival.ArchivePluginManager;
import dev.ftb.mods.ftbbackups.config.FTBBackupsServerConfig;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RestoreBackupScreen
extends Screen {
    private Button restoreButton;
    private BackupsList backupsList;
    private EditBox searchBox;
    private long totalFiles;
    private final AtomicLong currentFile = new AtomicLong(0L);
    private String restoringPath = "";
    private int completedTimer = 0;
    private String lastError = "";
    private static final ResourceLocation SUCCESS = ResourceLocation.withDefaultNamespace((String)"pending_invite/accept");
    private static final ResourceLocation FAILURE = ResourceLocation.withDefaultNamespace((String)"pending_invite/reject");
    static final int UPPER_HEIGHT = 80;
    static final int LOWER_HEIGHT = 40;
    private final Screen prevScreen;

    protected RestoreBackupScreen(Screen prevScreen, Component title) {
        super(title);
        this.prevScreen = prevScreen;
    }

    protected void init() {
        super.init();
        this.backupsList = new BackupsList(this.minecraft, this.width, this.height - 80 - 40, 80);
        this.searchBox = new EditBox(this.font, this.width / 2 - 80, 40, 160, 20, (Component)Component.empty());
        this.searchBox.setResponder(this.backupsList::onFilterChanged);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, btn -> this.onClose()).size(100, 20).pos(this.width / 2 - 130, this.height - 30).build());
        this.restoreButton = Button.builder((Component)Component.translatable((String)"ftbbackups3.gui.restore_now"), btn -> this.onActivate()).size(150, 20).pos(this.width / 2 - 20, this.height - 30).build();
        this.addRenderableWidget((GuiEventListener)this.restoreButton);
        this.restoreButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)this.backupsList);
    }

    private void onActivate() {
        BackupsList.Entry selected = (BackupsList.Entry)this.backupsList.getSelected();
        if (selected != null) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> this.doRestore(confirmed, selected), (Component)Component.translatable((String)"ftbbackups3.gui.confirm_restore", (Object[])new Object[]{selected.backup.worldName(), selected.backup.fileId()}), (Component)Component.translatable((String)"ftbbackups3.gui.confirm_restore.line_2")));
        }
    }

    private void doRestore(boolean confirmed, BackupsList.Entry selected) {
        this.minecraft.setScreen((Screen)this);
        if (confirmed) {
            Path backupsFolder = FTBBackupsServerConfig.getBackupFolder();
            Backup backup = selected.backup;
            IArchivalPlugin plugin = ArchivePluginManager.clientInstance().getPlugin(backup.archivalPlugin());
            if (plugin != null) {
                CompletableFuture.runAsync(() -> {
                    RestoreContext ctx = new RestoreContext(backupsFolder.resolve(backup.fileId()), FMLPaths.GAMEDIR.get(), Backups.LOGGER, this);
                    this.totalFiles = backup.fileCount();
                    this.currentFile.set(0L);
                    Backups.LOGGER.info("STUB: do restore! {} -> {}", (Object)ctx.archivePath(), (Object)ctx.destinationFolder());
                    try {
                        plugin.restoreArchive(ctx);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }).whenComplete((unused, ex) -> {
                    if (ex != null) {
                        Backups.LOGGER.error("backup restoration failed: {} -> {}", ex.getClass(), (Object)ex.getMessage());
                        this.lastError = ex.getMessage();
                    } else {
                        Backups.LOGGER.info("backup restoration complete!");
                        this.lastError = "";
                    }
                    this.totalFiles = 0L;
                    this.currentFile.set(0L);
                    this.restoringPath = "";
                    this.completedTimer = 50;
                });
            } else {
                Backups.LOGGER.info("unknown archival plugin {}!", (Object)backup.archivalPlugin());
            }
        }
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.searchBox);
    }

    public void onClose() {
        this.minecraft.setScreen(this.prevScreen);
    }

    public boolean shouldCloseOnEsc() {
        return this.totalFiles == 0L && super.shouldCloseOnEsc();
    }

    public void tick() {
        super.tick();
        if (this.completedTimer > 0) {
            --this.completedTimer;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        this.renderExtractionProgress(guiGraphics, this.totalFiles);
    }

    private void renderExtractionProgress(GuiGraphics guiGraphics, long total) {
        if (total == 0L && this.completedTimer == 0) {
            return;
        }
        int pw = guiGraphics.guiWidth() * 3 / 4;
        int ph = guiGraphics.guiHeight() / 4;
        int px = (guiGraphics.guiWidth() - pw) / 2;
        int py = (guiGraphics.guiHeight() - ph) / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        guiGraphics.fill(px - 2, py - 2, px + pw + 2, py + ph + 2, -12566464);
        guiGraphics.fill(px, py, px + pw, py + ph, -4144960);
        if (total > 0L) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"ftbbackups3.gui.restore.in_progress"), px + 5, py + 5, -12566464, false);
            MutableComponent mutableComponent = Component.literal((String)this.restoringPath);
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)mutableComponent, px + 5, py + ph - 9 - 5, -12566464, false);
            int sh = ph / 4;
            int sy = py + (ph - sh) / 2;
            guiGraphics.fill(px + 10, sy, px + pw - 10, sy + sh, -14671840);
            int sw = (int)((long)(pw - 24) * this.currentFile.get() / total);
            guiGraphics.fill(px + 12, sy + 2, px + 10 + sw, sy + sh - 2, -16760640);
            guiGraphics.pose().popPose();
        } else if (this.completedTimer > 0) {
            if (this.lastError.isEmpty()) {
                guiGraphics.blitSprite(SUCCESS, px + 10, py + (ph - 32) / 2, 0, 32, 32);
                MutableComponent mutableComponent = Component.translatable((String)"ftbbackups3.gui.restore.success");
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, (Component)mutableComponent, px + 50, py + (ph - 9) / 2, 0x404040, false);
            } else {
                guiGraphics.blitSprite(FAILURE, px + 10, py + (ph - 32) / 2, 0, 32, 32);
                MutableComponent mutableComponent = Component.translatable((String)"ftbbackups3.gui.restore.failure", (Object[])new Object[]{this.lastError});
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, (Component)mutableComponent, px + 50, py + (ph - 9) / 2, 0x404040, false);
            }
        }
    }

    private class BackupsList
    extends AbstractSelectionList<Entry> {
        public BackupsList(Minecraft minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 30);
            this.addChildren("");
        }

        private void addChildren(String filter) {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            String filterL = filter.toLowerCase(Locale.ROOT);
            for (Backup b : Backups.getClientInstance().backups()) {
                if (!b.success() || b.fileCount() <= 0 || !filter.isEmpty() && !b.worldName().toLowerCase(Locale.ROOT).contains(filterL)) continue;
                entries.add(new Entry(b));
            }
            this.children().addAll(entries.stream().sorted((o1, o2) -> o2.backup.compareTo(o1.backup)).toList());
        }

        protected void updateWidgetNarration(NarrationElementOutput ignored) {
        }

        public int getRowWidth() {
            return 400;
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 200;
        }

        public void setSelected(@Nullable Entry entry) {
            RestoreBackupScreen.this.restoreButton.active = entry != null;
            super.setSelected((AbstractSelectionList.Entry)entry);
        }

        private void onFilterChanged(String filter) {
            this.children().clear();
            this.addChildren(filter);
        }

        private class Entry
        extends AbstractSelectionList.Entry<Entry> {
            private static final String DATE_FORMAT = "MMM d, yyyy HH:mm a";
            private final Backup backup;
            private long lastClickTime;

            public Entry(Backup backup) {
                this.backup = backup;
            }

            public boolean mouseClicked(double x, double y, int partialTick) {
                BackupsList.this.setSelected(this);
                if (Util.getMillis() - this.lastClickTime < 250L) {
                    RestoreBackupScreen.this.onActivate();
                    return true;
                }
                this.lastClickTime = Util.getMillis();
                return false;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                Font font = Minecraft.getInstance().font;
                int startX = left + 80;
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
                ZonedDateTime ldt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.backup.time()), ZoneId.systemDefault());
                int y0 = top + 5;
                Objects.requireNonNull(font);
                int lh = 9 + 2;
                guiGraphics.drawString(font, (Component)Component.translatable((String)this.backup.worldName()), startX, y0, 0xFFFFFF);
                guiGraphics.drawString(font, (Component)Component.literal((String)ldt.format(formatter)), startX + 10, y0 + lh, 0xC0C0C0);
                if (this.isMouseOver(mouseX, mouseY)) {
                    RestoreBackupScreen.this.setTooltipForNextRenderPass(Stream.of(Component.translatable((String)"ftbbackups3.gui.list.file", (Object[])new Object[]{Component.literal((String)this.backup.fileId()).withStyle(ChatFormatting.GRAY)}), Component.translatable((String)"ftbbackups3.gui.list.plugin", (Object[])new Object[]{Component.literal((String)this.backup.archivalPlugin().toString()).withStyle(ChatFormatting.GRAY)})).map(MutableComponent::getVisualOrderText).toList());
                }
            }
        }
    }

    private record RestoreContext(Path archivePath, Path destinationFolder, Logger logger, RestoreBackupScreen screen) implements IArchivalPlugin.RestorationContext
    {
        @Override
        public void notifyProcessingFile(String filename) {
            this.screen.currentFile.incrementAndGet();
            this.screen.restoringPath = filename;
            this.logger.debug("restore file: {}", (Object)filename);
        }
    }
}

