/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.config;

import dev.ftb.mods.ftbbackups.Backups;
import dev.ftb.mods.ftbbackups.archival.ZipArchiver;
import dev.ftb.mods.ftbbackups.config.ArchivalPluginValue;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.util.Lazy;

public interface FTBBackupsServerConfig {
    public static final String KEY = "ftbbackups3-server";
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbbackups3-server").comment(new String[]{"Server-specific configuration for FTB Backups 3", "Modpack defaults should be defined in <instance>/config/ftbbackups3-server.snbt", "  (may be overwritten on modpack update)", "Server admins may locally override this by copying into <instance>/world/serverconfig/ftbbackups3-server.snbt", "  (will NOT be overwritten on modpack update)"});
    public static final String DEFAULT_BACKUP_FOLDER = "ftbbackups3";
    public static final BooleanValue AUTO = (BooleanValue)CONFIG.addBoolean("auto", true).comment(new String[]{"Enables backups to run automatically"});
    public static final BooleanValue SILENT = (BooleanValue)CONFIG.addBoolean("silent", false).comment(new String[]{"If set to true, no messages will be displayed in chat/status bar"});
    public static final IntValue BACKUPS_TO_KEEP = (IntValue)CONFIG.addInt("backups_to_keep", 12, 0, 32000).comment(new String[]{"The number of backup files to keep.", "More backups = more space used", "0 - Infinite"});
    public static final IntValue BACKUP_TIMER_MINUTES = (IntValue)CONFIG.addInt("backup_timer", 120, 1, 43800).comment(new String[]{"Backup frequency in minutes.", "5 - backups every 5 minutes", "60 - backups every hour", "360 - backups every 6 hours", "1440 - backups once every day"});
    public static final IntValue COMPRESSION_LEVEL = (IntValue)CONFIG.addInt("compression_level", 5, 0, 9).comment(new String[]{"Compression level for archived files. Note that this is dependent on the particular plugin in use.", "Higher values typically mean backups take longer to do but take less space on disk.", "0 - No compression", "1 - Minimal compression", "9 - Full compression"});
    public static final StringValue FOLDER = (StringValue)CONFIG.addString("folder", "").comment(new String[]{"Absolute path to backups folder. Default of \"\" means to use \"ftbackups3\" within the game instance folder."});
    public static final BooleanValue DISPLAY_FILE_SIZE = (BooleanValue)CONFIG.addBoolean("display_file_size", true).comment(new String[]{"Broadcasts to all online players a \"(current size | total size)\" message when backup is done."});
    public static final StringListValue EXTRA_FILES = (StringListValue)CONFIG.addStringList("extra_files", new ArrayList()).comment(new String[]{"Add extra files/folders to be backed up, in addition to the world folder. These files *must* be within the game instance!"});
    public static final StringValue MAX_TOTAL_SIZE_RAW = (StringValue)CONFIG.addString("max_total_size", "50 GB").comment(new String[]{"Maximum total size that is allowed in backups folder. Older backups will be deleted to free space for newer ones."});
    public static final BooleanValue ONLY_IF_PLAYERS_ONLINE = (BooleanValue)CONFIG.addBoolean("only_if_players_online", true).comment(new String[]{"Only create backups when at least one player is online."});
    public static final BooleanValue FORCE_ON_SHUTDOWN = (BooleanValue)CONFIG.addBoolean("force_on_shutdown", false).comment(new String[]{"Create a backup when server is stopped."});
    public static final SNBTConfig ADVANCED = (SNBTConfig)CONFIG.addGroup("advanced").comment(new String[]{"Advanced features that shouldn't be changed unless you know what you are doing."});
    public static final ArchivalPluginValue ARCHIVAL_PLUGIN = (ArchivalPluginValue)((ArchivalPluginValue)CONFIG.add((BaseValue)new ArchivalPluginValue(CONFIG, "archival_plugin", ZipArchiver.ID))).comment(new String[]{"Method to use to create a backup archive.", "Builtin methods are \"ftbbackups:zip\" (create a ZIP file) and \"ftbbackups:filecopy\" (simple recursive copy of files with no compression)", "More archival plugins may be added by other mods."});
    public static final StringListValue EXCLUDED_FILES = CONFIG.addStringList("excluded_files", List.of("glob:*.neoforge-tmp", "glob:session.lock"));
    public static final BooleanValue NOTIFY_ADMINS_ONLY = (BooleanValue)CONFIG.addBoolean("notify_admins_only", false).comment(new String[]{"If true, only player with permission level >= 2 (or SSP integrated server owners) will be notified on-screen about backup progress"});
    public static final IntValue BUFFER_SIZE = (IntValue)ADVANCED.addInt("buffer_size", 4096, 256, 65536).comment(new String[]{"Buffer size for reading/writing files."});
    public static final BooleanValue ADD_BACKUP_COMMAND_ALIAS = (BooleanValue)CONFIG.addBoolean("add_backup_command_alias", true).comment(new String[]{"If true, the /backup command will be aliased to /ftbbackups3 backup"});
    public static final Lazy<Long> MAX_TOTAL_SIZE = Lazy.of(() -> {
        String mts = (String)MAX_TOTAL_SIZE_RAW.get();
        long l = Long.parseLong(mts.substring(0, mts.length() - 2).trim());
        long maxTotalSize = mts.endsWith("TB") ? l * 0x10000000000L : (mts.endsWith("GB") ? l * 0x40000000L : (mts.endsWith("MB") ? l * 0x100000L : (mts.endsWith("KB") ? l * 1024L : Long.parseLong(mts.trim()))));
        return maxTotalSize;
    });
    public static final Lazy<List<PathMatcher>> EXCLUSION_MATCHERS = Lazy.of(() -> ((List)EXCLUDED_FILES.get()).stream().map(f -> FileSystems.getDefault().getPathMatcher((String)f)).toList());

    public static long getBackupTimerMillis() {
        return (long)((Integer)BACKUP_TIMER_MINUTES.get()).intValue() * 60000L;
    }

    public static void onConfigChanged(boolean ignoredIsServer) {
        MAX_TOTAL_SIZE.invalidate();
        EXCLUSION_MATCHERS.invalidate();
    }

    public static ResourceLocation archivalPlugin() {
        ResourceLocation rl = (ResourceLocation)ARCHIVAL_PLUGIN.get();
        if (rl == null) {
            Backups.LOGGER.error("Invalid archive plugin id {}, defaulting to ftbbackups:zip!", ARCHIVAL_PLUGIN.get());
            return ZipArchiver.ID;
        }
        return rl;
    }

    public static Path getBackupFolder() {
        String folder = (String)FOLDER.get();
        return folder.trim().isEmpty() ? FMLPaths.GAMEDIR.get().resolve(DEFAULT_BACKUP_FOLDER) : Paths.get(folder, new String[0]);
    }
}

