/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui;

import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.echo.progress.PerEchoProgress;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.net.RequestTeamProgressMessage;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class EchoProgressInfo
extends BaseScreen {
    private final TeamSelectionPanel teamSelectionPanel;
    private final TeamProgressInfoPanel teamProgressInfoPanel = new TeamProgressInfoPanel((Panel)this);
    private final PanelScrollBar teamSelectScrollBar;
    private final PanelScrollBar teamProgressScrollBar;

    public EchoProgressInfo() {
        this.teamSelectionPanel = new TeamSelectionPanel((Panel)this);
        this.teamSelectScrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, (Panel)this.teamSelectionPanel);
        this.teamProgressScrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, (Panel)this.teamProgressInfoPanel);
        Theme.renderDebugBoxes = false;
    }

    public boolean onInit() {
        List<Team> teams = FTBTeamsAPI.api().getClientManager().getTeams().stream().filter(Team::isPartyTeam).toList();
        teams.stream().findFirst().ifPresent(this::selectTeam);
        return true;
    }

    private void selectTeam(Team teamId) {
        this.teamProgressInfoPanel.setLoading(true);
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestTeamProgressMessage(teamId.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void addWidgets() {
        this.add((Widget)this.teamSelectionPanel);
        this.add((Widget)this.teamProgressInfoPanel);
        this.add((Widget)this.teamSelectScrollBar);
        this.add((Widget)this.teamProgressScrollBar);
    }

    public void alignWidgets() {
        super.alignWidgets();
        this.setPos(25, 25);
        this.setSize(this.getScreen().getGuiScaledWidth() - 50, this.getScreen().getGuiScaledHeight() - 50);
        int teamPanelWidth = 100;
        this.teamSelectionPanel.setPosAndSize(0, 0, teamPanelWidth, this.height);
        this.teamProgressInfoPanel.setPosAndSize(0, 0, this.width - (teamPanelWidth + 15), this.height);
        this.align((WidgetLayout)new WidgetLayout.Horizontal(0, 10, 0));
        this.teamSelectScrollBar.setPosAndSize(this.teamSelectionPanel.getPosX() + this.teamSelectionPanel.getWidth(), this.teamSelectionPanel.getPosY(), 6, this.teamSelectionPanel.getHeight());
        this.teamProgressScrollBar.setPosAndSize(this.teamProgressInfoPanel.getPosX() + this.teamProgressInfoPanel.getWidth(), this.teamProgressInfoPanel.getPosY(), 6, this.teamProgressInfoPanel.getHeight());
    }

    public void setProgress(UUID teamId, TeamProgress progress, Map<UUID, Component> referencedPlayers) {
        FTBTeamsAPI.api().getClientManager().getTeamByID(teamId).ifPresent(team -> this.teamProgressInfoPanel.setTeamProgress((Team)team, progress, referencedPlayers));
    }

    private static class TeamProgressInfoPanel
    extends Panel {
        TeamProgress progress = null;
        Team team = null;
        Map<UUID, Component> playerNames = new HashMap<UUID, Component>();
        boolean loading = false;
        TextField text;

        public TeamProgressInfoPanel(Panel panel) {
            super(panel);
        }

        public void addWidgets() {
            this.text = new TextField((Panel)this);
            if (this.progress != null) {
                MutableComponent processText = Component.empty().append("Progress for\n").append((Component)this.team.getName().copy().append("'s").withStyle(ChatFormatting.BOLD)).append("\n");
                for (Map.Entry<ResourceLocation, PerEchoProgress> echoProgress : this.progress.perEcho().entrySet()) {
                    ResourceLocation echoId = echoProgress.getKey();
                    PerEchoProgress perEchoProgress = echoProgress.getValue();
                    EchoManager instance = EchoManager.getInstance();
                    Optional<Echo> echo = instance.getEcho(echoId);
                    if (echo.isEmpty()) continue;
                    String echoName = echo.get().title().getString();
                    processText.append("\n\n");
                    int stage = perEchoProgress.getCurrentStage();
                    processText.append((Component)Component.literal((String)(echoName + " (Stage " + stage + ")")).withStyle(ChatFormatting.AQUA));
                    processText.append((Component)Component.literal((String)"\n\nStages\n").withStyle(ChatFormatting.YELLOW));
                    Map<UUID, Set<Integer>> playersClaimedRewards = perEchoProgress.claimedRewards();
                    for (int i = 0; i < perEchoProgress.getCurrentStage() + 2; ++i) {
                        List echoStages = echo.map(Echo::stages).orElse(Collections.emptyList());
                        boolean isCurrentStage = i == perEchoProgress.getCurrentStage();
                        String stageName = echoStages.size() > i ? ((EchoStage)echoStages.get(i)).title().getString() : "Stage " + i;
                        processText.append((Component)Component.literal((String)(stageName + (isCurrentStage ? " (current)\n" : "\n"))).withStyle(isCurrentStage ? ChatFormatting.GOLD : ChatFormatting.WHITE));
                        ArrayList<UUID> playersThatClaimed = new ArrayList<UUID>();
                        for (Map.Entry<UUID, Set<Integer>> entry : playersClaimedRewards.entrySet()) {
                            if (!entry.getValue().contains(i)) continue;
                            playersThatClaimed.add(entry.getKey());
                        }
                        if (!playersThatClaimed.isEmpty()) {
                            processText.append((Component)Component.literal((String)"Reward claimed by:\n").withStyle(ChatFormatting.GREEN));
                            for (UUID uuid : playersThatClaimed) {
                                Component playerName = this.playerNames.getOrDefault(uuid, (Component)Component.literal((String)uuid.toString()));
                                processText.append((Component)Component.literal((String)playerName.getString()).withStyle(ChatFormatting.GREEN));
                                boolean isLast = playersThatClaimed.indexOf(uuid) == playersThatClaimed.size() - 1;
                                if (isLast) continue;
                                processText.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GREEN));
                            }
                            processText.append("\n");
                        }
                        processText.append("\n");
                    }
                }
                this.text.setText((Component)processText);
            } else if (this.loading) {
                this.text.setText("Loading...");
            }
            this.add((Widget)this.text);
        }

        public void alignWidgets() {
            this.text.setPosAndSize(0, 5, this.width, this.height);
            if (this.text != null) {
                this.text.reflow();
            }
        }

        public void setTeamProgress(Team team, TeamProgress progress, Map<UUID, Component> playerNames) {
            this.progress = progress;
            this.team = team;
            this.loading = false;
            this.playerNames = playerNames;
            this.refreshWidgets();
        }

        public void setLoading(boolean loading) {
            this.loading = loading;
            this.refreshWidgets();
        }
    }

    private static class TeamSelectionPanel
    extends Panel {
        private final TextField title = new TextField((Panel)this).setText("Teams");

        public TeamSelectionPanel(Panel panel) {
            super(panel);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.drawBackground(graphics, theme, x, y, w, h);
            graphics.fill(x, y, x + w, y + h, 0x40000000);
        }

        public void addWidgets() {
            this.add((Widget)this.title);
            List<Team> teams = FTBTeamsAPI.api().getClientManager().getTeams().stream().filter(Team::isPartyTeam).toList();
            for (Team team : teams) {
                Color4I color = (Color4I)team.getProperty((TeamProperty)TeamProperties.COLOR);
                this.add((Widget)SimpleTextButton.create((Panel)this, (Component)team.getName(), (Icon)color.withPadding(4), mouseButton -> ((EchoProgressInfo)this.getGui()).selectTeam(team), (Component[])new Component[0]));
            }
        }

        public void alignWidgets() {
            this.title.setX(5);
            for (Widget widget : this.widgets) {
                if (!(widget instanceof SimpleTextButton)) continue;
                widget.setX(5);
                widget.setWidth(90);
            }
            this.align((WidgetLayout)new WidgetLayout.Vertical(5, 5, 0));
        }
    }
}

