/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui;

import dev.ftb.mods.ftbechoes.client.gui.widget.AudioButton;
import dev.ftb.mods.ftbechoes.client.gui.widget.ImageButton;
import dev.ftb.mods.ftbechoes.echo.BaseStageEntry;
import dev.ftb.mods.ftbechoes.echo.entries.AudioEntry;
import dev.ftb.mods.ftbechoes.echo.entries.ImageEntry;
import dev.ftb.mods.ftbechoes.echo.entries.TextEntry;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StageEntryRenderers {
    private static final Map<String, EntryRenderer<? extends BaseStageEntry>> map = new HashMap<String, EntryRenderer<? extends BaseStageEntry>>();

    public static void init() {
        map.put("text", new TextEntryRenderer());
        map.put("image", new ImageRenderer());
        map.put("audio", new AudioRenderer());
    }

    public static Optional<EntryRenderer<? extends BaseStageEntry>> get(BaseStageEntry entry) {
        return Optional.ofNullable(map.get(entry.getTypeId()));
    }

    public static class TextEntryRenderer
    implements EntryRenderer<TextEntry> {
        @Override
        public void addWidgets(Consumer<Widget> widgetAdder, BaseStageEntry entry, Panel panel) {
            TextEntry t = (TextEntry)this.cast(entry);
            TextField textWidget = new TextField(panel).setText(t.text());
            textWidget.setX(2);
            widgetAdder.accept((Widget)textWidget);
        }
    }

    public static class ImageRenderer
    implements EntryRenderer<ImageEntry> {
        @Override
        public void addWidgets(Consumer<Widget> widgetAdder, BaseStageEntry entry, Panel panel) {
            ImageEntry im = (ImageEntry)this.cast(entry);
            ImageButton btn = new ImageButton(panel, Icon.getIcon((ResourceLocation)im.location()), im.alignment());
            btn.setSize(im.width(), im.height());
            widgetAdder.accept((Widget)btn);
        }
    }

    public static class AudioRenderer
    implements EntryRenderer<AudioEntry> {
        @Override
        public void addWidgets(Consumer<Widget> widgetAdder, BaseStageEntry entry, Panel panel) {
            AudioEntry a = (AudioEntry)this.cast(entry);
            AudioButton btn = new AudioButton(panel, a.text().orElse((Component)Component.empty()), a.location());
            btn.setX(2);
            widgetAdder.accept((Widget)btn);
        }
    }

    @FunctionalInterface
    public static interface EntryRenderer<T extends BaseStageEntry> {
        public void addWidgets(Consumer<Widget> var1, BaseStageEntry var2, Panel var3);

        default public T cast(BaseStageEntry entry) {
            return (T)entry;
        }
    }
}

