/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.integration.quests;

import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FTBQuestsIntegration {
    public static List<Component> getLootData(ShopData data) {
        boolean foundLootItem = false;
        ArrayList<Component> components = new ArrayList<Component>();
        List<ItemStack> stacks = data.stacks();
        for (ItemStack stack : stacks) {
            LootCrate crate;
            Item item = stack.getItem();
            if (!(item instanceof LootCrateItem) || (crate = LootCrateItem.getCrate((ItemStack)stack, (boolean)true)) == null) continue;
            if (foundLootItem) {
                components.add((Component)Component.literal((String)""));
            }
            foundLootItem = true;
            RewardTable table = crate.getTable();
            float totalWeight = table.getTotalWeight(true);
            List weightedRewards = table.getWeightedRewards().stream().sorted((a, b) -> {
                float aChance = a.getWeight() / totalWeight;
                float bChance = b.getWeight() / totalWeight;
                return Float.compare(bChance, aChance);
            }).toList();
            for (WeightedReward weightedReward : weightedRewards) {
                Reward reward = weightedReward.getReward();
                float weight = weightedReward.getWeight();
                components.add((Component)reward.getTitle().copy().append((Component)Component.literal((String)(" [" + WeightedReward.chanceString((float)weight, (float)totalWeight) + "]")).withStyle(ChatFormatting.DARK_GRAY)));
            }
        }
        if (foundLootItem) {
            return components;
        }
        return null;
    }
}

