/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.config;

import dev.ftb.mods.ftbessentials.config.PermissionBasedBooleanValue;
import dev.ftb.mods.ftbessentials.config.PermissionBasedIntValue;
import dev.ftb.mods.ftbessentials.config.TimedCommandConfig;
import dev.ftb.mods.ftbessentials.config.ToggleableConfig;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import java.util.List;

public interface FTBEConfig {
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbessentials").comment(new String[]{"FTB Essentials config file", "If you're a modpack maker, edit defaultconfigs/ftbessentials-server.snbt instead"});
    public static final BooleanValue REGISTER_TO_NAMESPACE = (BooleanValue)CONFIG.addBoolean("register_to_namespace", false).comment(new String[]{"If true, the mod will register its commands to the 'ftbessentials' namespace,", "otherwise it will register to the root namespace"});
    public static final BooleanValue REGISTER_ALIAS_AS_WELL_AS_NAMESPACE = (BooleanValue)CONFIG.addBoolean("register_alias_as_well_as_namespace", false).comment(new String[]{"If true, the mod will register its commands to the 'ftbessentials' namespace as well as the root namespace", "otherwise it will only register to the root namespace", "This setting has no effect if 'register_to_namespace' is false"});
    public static final SNBTConfig INTEGRATION = (SNBTConfig)CONFIG.addGroup("integration").comment(new String[]{"Cross-mod integration"});
    public static final BooleanValue TEAM_BASES_SPAWN_OVERRIDE = (BooleanValue)INTEGRATION.addBoolean("team_bases_spawn_override", true).comment(new String[]{"If true, and FTB Team Bases is installed, then the '/spawn' command will instead send players to the lobby"});
    public static final SNBTConfig TELEPORTATION = (SNBTConfig)CONFIG.addGroup("teleportation").comment(new String[]{"Teleportation-related settings"});
    public static final BooleanValue ADMINS_EXEMPT_DIMENSION_BLACKLISTS = (BooleanValue)TELEPORTATION.addBoolean("admins_exempt_dimension_blacklists", true).comment(new String[]{"If true, admin-level players (i.e. permission level >= 2) are exempt from", "the dimension controls defined in teleportation -> blacklists and", "in teleportation -> rtp -> dimension_blacklist/whitelist"});
    public static final TimedCommandConfig BACK = new TimedCommandConfig(TELEPORTATION, "back", 30, 0).comment("Allows users to return to their previous location after teleporting (or dying)");
    public static final PermissionBasedIntValue MAX_BACK = new PermissionBasedIntValue((IntValue)FTBEConfig.BACK.config.addInt("max", 10).range((Number)0, (Number)Integer.MAX_VALUE), "ftbessentials.back.max", "Max size of the teleport history. This limits how many times you can use /back");
    public static final BooleanValue BACK_ON_DEATH_ONLY = (BooleanValue)FTBEConfig.BACK.config.addBoolean("only_on_death", false).comment(new String[]{"Should be the /back command only be used for returning to the last death point?"});
    public static final TimedCommandConfig SPAWN = new TimedCommandConfig(TELEPORTATION, "spawn", 10, 0);
    public static final TimedCommandConfig PLAYER_SPAWN = new TimedCommandConfig(TELEPORTATION, "playerspawn", 10, 0);
    public static final TimedCommandConfig WARP = new TimedCommandConfig(TELEPORTATION, "warp", 10, 0).comment("Allows admins to create 'warps', which are fixed points in the world that users may teleport to using /warp");
    public static final TimedCommandConfig HOME = new TimedCommandConfig(TELEPORTATION, "home", 10, 0).comment("Allows users to set 'homes', which they can then freely teleport to by using /home afterwards");
    public static final PermissionBasedIntValue MAX_HOMES = new PermissionBasedIntValue((IntValue)FTBEConfig.HOME.config.addInt("max", 1).range((Number)0, (Number)Integer.MAX_VALUE), "ftbessentials.home.max", "Max amount of homes a user can have.");
    public static final IntValue HOME_MIN_Y = (IntValue)FTBEConfig.HOME.config.addInt("home_min_y", Integer.MIN_VALUE).comment(new String[]{"The minimum Y value for homes, as set by the /sethome command"});
    public static final TimedCommandConfig TPA = new TimedCommandConfig(TELEPORTATION, "tpa", 10, 0).comment("Allows players to create requests to teleport to other users on the server,", "as well as requesting other players to teleport to them");
    public static final TimedCommandConfig RTP = new TimedCommandConfig(TELEPORTATION, "rtp", 600, 0).comment("Allows players to teleport to a random point in the Wilderness", "Note: This currently does not respect Claimed Chunks yet!");
    public static final IntValue RTP_MAX_TRIES = (IntValue)FTBEConfig.RTP.config.addInt("max_tries", 100).range((Number)1, (Number)1000).comment(new String[]{"Number of tries before /rtp gives up"});
    public static final IntValue RTP_MIN_DISTANCE = (IntValue)FTBEConfig.RTP.config.addInt("min_distance", 500).range((Number)0, (Number)30000000).comment(new String[]{"/rtp min distance from spawn point"});
    public static final IntValue RTP_MAX_DISTANCE = (IntValue)FTBEConfig.RTP.config.addInt("max_distance", 25000).range((Number)0, (Number)30000000).comment(new String[]{"/rtp max distance from spawn point"});
    public static final StringListValue RTP_DIMENSION_WHITELIST = (StringListValue)FTBEConfig.RTP.config.addStringList("dimension_whitelist", List.of()).comment(new String[]{"Whitelisted dimension ID's for /rtp (if non-empty, player *must* be in one of these dimensions)", "Wildcarded dimensions (e.g. 'somemod:*') are supported"});
    public static final StringListValue RTP_DIMENSION_BLACKLIST = (StringListValue)FTBEConfig.RTP.config.addStringList("dimension_blacklist", List.of("minecraft:the_end")).comment(new String[]{"Blacklisted dimension ID's for /rtp (player *must not* be in any of these dimensions)", "Wildcarded dimensions (e.g. 'somemod:*') are supported"});
    public static final PermissionBasedBooleanValue RTP_MAX_DISTANCE_CUSTOM = new PermissionBasedBooleanValue(FTBEConfig.RTP.config.addBoolean("allow_custom_max_distance", false), "ftbessentials.rtp.custom_max", "Allow player to specify (only) custom max distance in rtp command");
    public static final PermissionBasedBooleanValue RTP_MIN_DISTANCE_CUSTOM = new PermissionBasedBooleanValue(FTBEConfig.RTP.config.addBoolean("allow_custom_min_max_distance", false), "ftbessentials.rtp.custom_min_max", "Allow player to specify custom min and max distance in rtp command");
    public static final ToggleableConfig TPL = new ToggleableConfig(TELEPORTATION, "tpl").comment("Allows admins to teleport to the location a user was last seen at");
    public static final ToggleableConfig TPX = new ToggleableConfig(TELEPORTATION, "tpx").comment("Allows admins to teleport to dimension");
    public static final ToggleableConfig JUMP = new ToggleableConfig(TELEPORTATION, "jump").comment("Allows admins to jump (teleport) to the focused block");
    public static final SNBTConfig TELEPORTATION_BLACKLISTS = (SNBTConfig)TELEPORTATION.addGroup("blacklists").comment(new String[]{"Blacklists for all teleport commands", "Wildcarded dimensions (e.g. 'somemod:*') are supported"});
    public static final StringListValue TELEPORTATION_BLACKLIST_FROM = (StringListValue)TELEPORTATION_BLACKLISTS.addStringList("from", List.of()).comment(new String[]{"Dimensions players aren't permitted to run teleport commands in."});
    public static final StringListValue TELEPORTATION_BLACKLIST_TO = (StringListValue)TELEPORTATION_BLACKLISTS.addStringList("to", List.of()).comment(new String[]{"Dimensions players aren't permitted to teleport into."});
    public static final SNBTConfig ADMIN = (SNBTConfig)CONFIG.addGroup("admin").comment(new String[]{"Admin commands for cheating and moderation"});
    public static final ToggleableConfig HEAL = new ToggleableConfig(ADMIN, "heal").comment("Allows admins to fully heal (health, food, fire, potion effects) themselves or a player using a command");
    public static final ToggleableConfig FEED = new ToggleableConfig(ADMIN, "feed").comment("Allows admins to fully feed themselves or a player using a command");
    public static final ToggleableConfig EXTINGUISH = new ToggleableConfig(ADMIN, "extinguish").comment("Allows admins to extinguish themselves or a player using a command");
    public static final ToggleableConfig FLY = new ToggleableConfig(ADMIN, "fly").comment("Allows admins to toggle flying status using a command, without having to use Creative Mode");
    public static final ToggleableConfig SPEED = new ToggleableConfig(ADMIN, "speed").comment("Allows admins to change walk speed for themselves or a player");
    public static final ToggleableConfig GOD = new ToggleableConfig(ADMIN, "god").comment("Allows admins to toggle invincibility using a command, without having to use Creative Mode");
    public static final ToggleableConfig INVSEE = new ToggleableConfig(ADMIN, "invsee").comment("Allows admins to view other users' inventories using a command");
    public static final ToggleableConfig MUTE = new ToggleableConfig(ADMIN, "mute").comment("Allows admins to restrict players from chatting by using a command to mute (or unmute) them");
    public static final ToggleableConfig KIT = new ToggleableConfig(ADMIN, "kit").comment("Allows admins to configure kits of items that can be given to players.");
    public static final ToggleableConfig TP_OFFLINE = new ToggleableConfig(ADMIN, "tp_offline").comment("Allows admins to change the location of offline players.");
    public static final SNBTConfig MISC = (SNBTConfig)CONFIG.addGroup("misc").comment(new String[]{"Miscellaneous features and utilities"});
    public static final ToggleableConfig KICKME = new ToggleableConfig(MISC, "kickme").comment("Allows users to kick themselves from the server, for example if they are stuck or desynced");
    public static final ToggleableConfig TRASHCAN = new ToggleableConfig(MISC, "trashcan").comment("Enables usage of a trash can inventory, which can be used to void unneeded items");
    public static final ToggleableConfig REC = new ToggleableConfig(MISC, "rec").comment("Allows users to announce their recording or streaming status to the server by using commands");
    public static final ToggleableConfig HAT = new ToggleableConfig(MISC, "hat").comment("Allows users to set a custom hat as their head item by using a command");
    public static final ToggleableConfig NICK = new ToggleableConfig(MISC, "nick").comment("Allows users to change their display name, as well as admins to change nicknames for other users");
    public static final ToggleableConfig ENDER_CHEST = new ToggleableConfig(MISC, "enderchest").comment("Allows users to access their ender chest, as well as admins to manage other players' ender chests.");
    public static final ToggleableConfig CRAFTING_TABLE = new ToggleableConfig(MISC, "crafting").comment("Allows users to access a Crafting Table GUI without needing a Crafting Table.");
    public static final ToggleableConfig STONECUTTER = new ToggleableConfig(MISC, "stonecutter").comment("Allows users to access a Stonecutter GUI without needing a Stonecutter.");
    public static final ToggleableConfig ANVIL = new ToggleableConfig(MISC, "anvil").comment("Allows users to access an Anvil GUI without needing an Anvil.");
    public static final ToggleableConfig SMITHING_TABLE = new ToggleableConfig(MISC, "smithing").comment("Allows users to access a Smithing Table GUI without needing a Smithing Table.");
    public static final ToggleableConfig LEADERBOARD = new ToggleableConfig(MISC, "leaderboard").comment("Allows users to view leaderboard stats about everyone on the server.");
    public static final ToggleableConfig NEAR = new ToggleableConfig(MISC, "near").comment("Allows users to list nearby players, sorted by distance");
}

